/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.catalog.model.system.EnvironmentLabel;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.model.system.SystemModelSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.AbstractSystemEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystemLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroupLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportSystemsAndInstructionsResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.IgnoreResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.system.ImportSystemResult;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSystemObject;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.ImportSystemStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.SystemDeserializationResult;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.remote.SystemCompareAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ServicesNotFoundException;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportMode;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.system.SystemsCommitRequest;
import org.qubership.integration.platform.runtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.runtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.deserializer.ServiceDeserializer;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.instructions.ImportInstructionsService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer.ServiceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class SystemExportImportService {
    private static final Logger log = LoggerFactory.getLogger(SystemExportImportService.class);
    private static final String LIB_COMPILATION_ERROR = "Failed to compile libraries for service specifications: ";
    private static final String SYSTEM_SAVED_DDL_ERROR = "System has been saved, but with DDL script execution error. ";
    private static final String CHAINS_REDEPLOY_NEEDED_MSG = "There are changes in environment address. Please redeploy affected chains (if any)";
    private static final String SPECIFICATION_EXISTS_ERROR_MESSAGE_START = "Specification with the version '";
    private static final String SPECIFICATION_EXISTS_BY_ID_ERROR_MESSAGE_START = "Specification with id '";
    private static final String SPECIFICATION_EXISTS_ERROR_MESSAGE_END = "' was not imported. ";
    protected static final String CONFIG_DEPLOY_LABELS = "deployLabels";
    private final TransactionTemplate transactionTemplate;
    private final YAMLMapper yamlMapper;
    private final SystemService systemService;
    private final SystemModelService systemModelService;
    private final EnvironmentService environmentService;
    protected final ActionsLogService actionLogger;
    private final AuditingHandler auditingHandler;
    private final ServiceSerializer serviceSerializer;
    private final ServiceDeserializer serviceDeserializer;
    private final ImportSessionService importProgressService;
    private final ImportInstructionsService importInstructionsService;
    @Value(value="${qip.export.remove-unused-specifications}")
    private boolean removeUnusedSpecs;

    @Autowired
    public SystemExportImportService(TransactionTemplate transactionTemplate, SystemService systemService, EnvironmentService environmentService, SystemModelService systemModelService, YAMLMapper yamlExportImportMapper, ActionsLogService actionLogger, AuditingHandler jpaAuditingHandler, ServiceSerializer serviceSerializer, ServiceDeserializer serviceDeserializer, ImportSessionService importProgressService, ImportInstructionsService importInstructionsService) {
        this.transactionTemplate = transactionTemplate;
        this.yamlMapper = yamlExportImportMapper;
        this.systemService = systemService;
        this.environmentService = environmentService;
        this.systemModelService = systemModelService;
        this.actionLogger = actionLogger;
        this.auditingHandler = jpaAuditingHandler;
        this.serviceSerializer = serviceSerializer;
        this.serviceDeserializer = serviceDeserializer;
        this.importProgressService = importProgressService;
        this.importInstructionsService = importInstructionsService;
    }

    private void removeUnusedSpecifications(IntegrationSystem integrationSystem, List<String> usedSystemModelIds) {
        ArrayList<SpecificationGroup> specificationGroupToRemove = new ArrayList<SpecificationGroup>();
        for (SpecificationGroup specificationGroup : integrationSystem.getSpecificationGroups()) {
            ArrayList<SystemModel> systemModelsToRemove = new ArrayList<SystemModel>();
            for (SystemModel systemModel : specificationGroup.getSystemModels()) {
                if (usedSystemModelIds.contains(systemModel.getId())) continue;
                systemModelsToRemove.add(systemModel);
            }
            specificationGroup.getSystemModels().removeAll(systemModelsToRemove);
            if (!specificationGroup.getSystemModels().isEmpty()) continue;
            specificationGroupToRemove.add(specificationGroup);
        }
        integrationSystem.getSpecificationGroups().removeAll(specificationGroupToRemove);
    }

    private ExportedSystemObject exportOneSystem(IntegrationSystem system, List<String> usedSystemModelIds) {
        try {
            if (system != null) {
                if (this.removeUnusedSpecs && !CollectionUtils.isEmpty(usedSystemModelIds)) {
                    this.removeUnusedSpecifications(system, usedSystemModelIds);
                }
            } else {
                throw new IllegalArgumentException("Unsupported system type");
            }
            ExportedSystemObject exportedSystem = this.serviceSerializer.serialize(system);
            return exportedSystem;
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            String systemId = system != null && system.getId() != null ? "with system id: " + system.getId() + " " : "";
            String errMessage = "Error while serializing system " + systemId + e.getMessage();
            log.error(errMessage);
            throw new RuntimeException(errMessage, e);
        }
    }

    private List<ExportedSystemObject> exportSystems(List<IntegrationSystem> systems, List<String> usedSystemModelIds) {
        return systems.stream().map(system -> this.exportOneSystem((IntegrationSystem)system, usedSystemModelIds)).collect(Collectors.toList());
    }

    public byte[] exportSystemsRequest(List<String> systemIds, List<String> usedSystemModelIds) {
        ArrayList<IntegrationSystem> systems = new ArrayList<IntegrationSystem>();
        if (systemIds == null) {
            systems.addAll(this.systemService.getAll());
        } else {
            systems.addAll(systemIds.stream().map(arg_0 -> ((SystemService)this.systemService).getByIdOrNull(arg_0)).filter(Objects::nonNull).toList());
        }
        if (systems.isEmpty()) {
            return null;
        }
        List<ExportedSystemObject> exportedSystems = this.exportSystems(systems, usedSystemModelIds);
        byte[] archive = this.serviceSerializer.writeSerializedArchive(exportedSystems);
        for (IntegrationSystem system : systems) {
            this.logSystemExportImport(system, null, LogOperation.EXPORT);
        }
        return archive;
    }

    public List<ImportSystemResult> getSystemsImportPreviewRequest(MultipartFile file) {
        String exportDirectory;
        ArrayList<ImportSystemResult> response = new ArrayList<ImportSystemResult>();
        String fileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if ("zip".equalsIgnoreCase(fileExtension)) {
            exportDirectory = Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), UUID.randomUUID().toString()).toString();
            List extractedSystemFiles = new ArrayList();
            try (InputStream fs = file.getInputStream();){
                extractedSystemFiles = ExportImportUtils.extractSystemsFromZip((InputStream)fs, (String)exportDirectory);
            }
            catch (ServicesNotFoundException e) {
                ExportImportUtils.deleteFile((String)exportDirectory);
            }
            catch (IOException e) {
                ExportImportUtils.deleteFile((String)exportDirectory);
                throw new RuntimeException("Unexpected error while archive unpacking: " + e.getMessage(), e);
            }
            catch (RuntimeException e) {
                ExportImportUtils.deleteFile((String)exportDirectory);
                throw e;
            }
            ImportInstructionsConfig instructionsConfig = this.importInstructionsService.getServiceImportInstructionsConfig(Set.of(ImportInstructionAction.IGNORE));
            for (File singleSystemFile : extractedSystemFiles) {
                response.add(this.getSystemChanges(singleSystemFile, instructionsConfig));
            }
        } else {
            throw new RuntimeException("Unsupported file extension: " + fileExtension);
        }
        ExportImportUtils.deleteFile((String)exportDirectory);
        return response;
    }

    public List<ImportSystemResult> getSystemsImportPreview(File importDirectory, ImportInstructionsConfig instructionsConfig) {
        List systemsFiles;
        try {
            systemsFiles = ExportImportUtils.extractSystemsFromImportDirectory((String)importDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while extracting systems", e);
        }
        ArrayList<ImportSystemResult> importSystemResults = new ArrayList<ImportSystemResult>();
        for (File systemFile : systemsFiles) {
            importSystemResults.add(this.getSystemChanges(systemFile, instructionsConfig));
        }
        return importSystemResults;
    }

    protected ImportSystemResult getSystemChanges(File mainSystemFile, ImportInstructionsConfig instructionsConfig) {
        Object resultSystemCompareDTO;
        String systemId = null;
        String systemName = null;
        try {
            ObjectNode serviceNode = this.getFileNode(mainSystemFile);
            SystemDeserializationResult deserializationResult = this.getBaseSystemDeserializationResult((JsonNode)serviceNode);
            IntegrationSystem baseSystem = deserializationResult.getSystem();
            systemId = baseSystem.getId();
            systemName = baseSystem.getName();
            Long systemModifiedWhen = baseSystem.getModifiedWhen() != null ? baseSystem.getModifiedWhen().getTime() : 0L;
            ImportInstructionAction instructionAction = instructionsConfig.getIgnore().contains(systemId) ? ImportInstructionAction.IGNORE : null;
            resultSystemCompareDTO = ((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(systemId)).modified(systemModifiedWhen)).instructionAction(instructionAction)).build();
            this.setCompareSystemResult(baseSystem, (ImportSystemResult)resultSystemCompareDTO);
        }
        catch (IOException | RuntimeException e) {
            log.error("Exception while system compare: ", (Throwable)e);
            resultSystemCompareDTO = ((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(systemId)).name(systemName)).requiredAction(SystemCompareAction.ERROR)).message("Exception while system compare: " + e.getMessage())).build();
        }
        return resultSystemCompareDTO;
    }

    private void setCompareSystemResult(IntegrationSystem system, ImportSystemResult resultSystemCompareDTO) {
        IntegrationSystem oldSystem = this.systemService.getByIdOrNull(system.getId());
        if (oldSystem == null) {
            resultSystemCompareDTO.setName(system.getName());
            resultSystemCompareDTO.setRequiredAction(SystemCompareAction.CREATE);
        } else {
            resultSystemCompareDTO.setName(oldSystem.getName());
            resultSystemCompareDTO.setRequiredAction(SystemCompareAction.UPDATE);
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public List<ImportSystemResult> importSystemRequest(MultipartFile importFile, List<String> systemIds, String deployLabel, Set<String> technicalLabels) {
        String exportDirectory;
        ArrayList<ImportSystemResult> response = new ArrayList<ImportSystemResult>();
        String fileExtension = FilenameUtils.getExtension((String)importFile.getOriginalFilename());
        this.logSystemExportImport(null, importFile.getOriginalFilename(), LogOperation.IMPORT);
        if ("zip".equalsIgnoreCase(fileExtension)) {
            List extractedSystemFiles;
            exportDirectory = Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), UUID.randomUUID().toString()).toString();
            try (InputStream fs = importFile.getInputStream();){
                extractedSystemFiles = ExportImportUtils.extractSystemsFromZip((InputStream)fs, (String)exportDirectory);
            }
            catch (IOException e) {
                ExportImportUtils.deleteFile((String)exportDirectory);
                throw new RuntimeException("Unexpected error while archive unpacking: " + e.getMessage(), e);
            }
            catch (RuntimeException e) {
                ExportImportUtils.deleteFile((String)exportDirectory);
                throw e;
            }
            Set<String> servicesToImport = this.importInstructionsService.performServiceIgnoreInstructions(extractedSystemFiles.stream().map(ExportImportUtils::extractSystemIdFromFileName).collect(Collectors.toSet()), false).idsToImport();
            for (File singleSystemFile : extractedSystemFiles) {
                String serviceId = ExportImportUtils.extractSystemIdFromFileName((File)singleSystemFile);
                if (!servicesToImport.contains(serviceId)) {
                    response.add((ImportSystemResult)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(serviceId)).name(serviceId)).status(ImportSystemStatus.IGNORED)).build());
                    log.info("Service {} ignored as a part of import exclusion list", (Object)serviceId);
                    continue;
                }
                ImportSystemResult result = this.importOneSystemInTransaction(singleSystemFile, deployLabel, systemIds, technicalLabels);
                if (result == null) continue;
                response.add(result);
            }
        } else {
            throw new RuntimeException("Unsupported file extension: " + fileExtension);
        }
        ExportImportUtils.deleteFile((String)exportDirectory);
        return response;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ImportSystemsAndInstructionsResult importSystems(File importDirectory, SystemsCommitRequest systemCommitRequest, String importId, Set<String> technicalLabels) {
        List systemsFiles;
        if (systemCommitRequest.getImportMode() == ImportMode.NONE) {
            return new ImportSystemsAndInstructionsResult();
        }
        try {
            systemsFiles = ExportImportUtils.extractSystemsFromImportDirectory((String)importDirectory.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while archive unpacking: " + e.getMessage(), e);
        }
        String deployLabel = systemCommitRequest.getDeployLabel();
        List<String> systemIds = systemCommitRequest.getImportMode() == ImportMode.FULL ? Collections.emptyList() : systemCommitRequest.getSystemIds();
        IgnoreResult ignoreResult = this.importInstructionsService.performServiceIgnoreInstructions(systemsFiles.stream().map(ExportImportUtils::extractSystemIdFromFileName).collect(Collectors.toSet()), true);
        int total = systemsFiles.size();
        int counter = 0;
        ArrayList<ImportSystemResult> response = new ArrayList<ImportSystemResult>();
        for (File systemFile : systemsFiles) {
            String serviceId = ExportImportUtils.extractSystemIdFromFileName((File)systemFile);
            if (!ignoreResult.idsToImport().contains(serviceId)) {
                response.add((ImportSystemResult)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(serviceId)).name(serviceId)).status(ImportSystemStatus.IGNORED)).build());
                log.info("Service {} ignored as a part of import exclusion list", (Object)serviceId);
                continue;
            }
            this.importProgressService.calculateImportStatus(importId, total, counter, 10, 30);
            ++counter;
            ImportSystemResult result = this.importOneSystemInTransaction(systemFile, deployLabel, systemIds, technicalLabels);
            if (result == null) continue;
            response.add(result);
        }
        return new ImportSystemsAndInstructionsResult(response, ignoreResult.importInstructionResults());
    }

    protected synchronized ImportSystemResult importOneSystemInTransaction(File mainServiceFile, String deployLabel, List<String> systemIds, Set<String> technicalLabels) {
        Object result;
        Optional<IntegrationSystem> baseSystemOptional = Optional.empty();
        try {
            ObjectNode serviceNode = this.getFileNode(mainServiceFile);
            SystemDeserializationResult deserializationResult = this.getBaseSystemDeserializationResult((JsonNode)serviceNode);
            baseSystemOptional = Optional.ofNullable(deserializationResult.getSystem());
            result = (ImportSystemResult)this.transactionTemplate.execute(status -> {
                File serviceDirectory = mainServiceFile.getParentFile();
                IntegrationSystem baseSystem = deserializationResult.getSystem();
                if (!CollectionUtils.isEmpty((Collection)systemIds) && !systemIds.contains(baseSystem.getId())) {
                    return null;
                }
                deserializationResult.setSystem(this.serviceDeserializer.deserializeSystem(serviceNode, serviceDirectory));
                StringBuilder message = new StringBuilder();
                ImportSystemStatus importStatus = this.enrichAndSaveIntegrationSystem(deserializationResult, deployLabel, technicalLabels, message::append);
                return ((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(deserializationResult.getSystem().getId())).name(deserializationResult.getSystem().getName())).status(importStatus)).message(message.toString())).build();
            });
        }
        catch (Exception e) {
            result = ((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)((ImportSystemResult.ImportSystemResultBuilder)ImportSystemResult.builder().id(baseSystemOptional.map(AbstractEntity::getId).orElse(null))).name(baseSystemOptional.map(AbstractEntity::getName).orElse(""))).status(ImportSystemStatus.ERROR)).message(e.getMessage())).build();
            log.warn("Exception when importing system {} ({})", new Object[]{((ImportSystemResult)result).getName(), ((ImportSystemResult)result).getId(), e});
        }
        return result;
    }

    private ImportSystemStatus enrichAndSaveIntegrationSystem(SystemDeserializationResult deserializationResult, String deployLabel, Set<String> technicalLabels, Consumer<String> messageHandler) {
        ImportSystemStatus status;
        IntegrationSystem system = deserializationResult.getSystem();
        this.checkSpecificationUniqueness(system);
        IntegrationSystem oldSystem = this.systemService.getByIdOrNull(system.getId());
        this.replaceSystemTechnicalLabels(system, oldSystem, technicalLabels);
        ArrayList<SystemModel> newSystemModels = new ArrayList<SystemModel>();
        if (oldSystem != null) {
            status = ImportSystemStatus.UPDATED;
            newSystemModels.addAll(this.prepareIntegrationSystemForUpdate(system, oldSystem, deployLabel, messageHandler, technicalLabels));
        } else {
            status = ImportSystemStatus.CREATED;
            this.prepareIntegrationSystemForCreate(system, deployLabel, messageHandler);
            system.getSpecificationGroups().stream().map(SpecificationGroup::getSystemModels).flatMap(Collection::stream).forEach(newSystemModels::add);
        }
        this.touchSystemFields(system);
        StringBuilder compilationErrors = new StringBuilder();
        boolean hasErrors = this.compileSystemModelLibraries(newSystemModels, str -> compilationErrors.append((String)str).append(" "));
        if (hasErrors) {
            throw new RuntimeException(LIB_COMPILATION_ERROR + String.valueOf(compilationErrors));
        }
        if (oldSystem != null) {
            this.systemService.update(system);
        } else {
            this.systemService.create(system, true);
        }
        return status;
    }

    private boolean compileSystemModelLibraries(Collection<SystemModel> models, Consumer<String> errorHandler) {
        return models.stream().map(model -> {
            try {
                this.systemModelService.patchModelWithCompiledLibrary((SystemModel)model);
                return false;
            }
            catch (Exception exception) {
                errorHandler.accept(exception.getMessage());
                return true;
            }
        }).reduce(false, (r1, r2) -> r1 != false || r2 != false);
    }

    private void touchSystemFields(IntegrationSystem system) {
        system.getEnvironments().forEach(arg_0 -> ((AuditingHandler)this.auditingHandler).markModified(arg_0));
        system.getSpecificationGroups().forEach(specificationGroup -> {
            this.auditingHandler.markModified(specificationGroup);
            specificationGroup.getSystemModels().forEach(systemModel -> {
                this.auditingHandler.markModified(systemModel);
                systemModel.getOperations().forEach(arg_0 -> ((AuditingHandler)this.auditingHandler).markModified(arg_0));
            });
        });
    }

    private Collection<SystemModel> prepareIntegrationSystemForUpdate(IntegrationSystem newSystem, IntegrationSystem oldSystem, String deployLabel, Consumer<String> messageHandler, Set<String> technicalLabels) {
        if (IntegrationSystemType.INTERNAL == newSystem.getIntegrationSystemType()) {
            Environment oldEnvironment;
            if (newSystem.getEnvironments().size() > 1) {
                throw new RuntimeException("Can't have more than 1 environment on internal system");
            }
            Environment environment = newSystem.getEnvironments().isEmpty() ? null : (Environment)newSystem.getEnvironments().get(0);
            Environment environment2 = oldEnvironment = oldSystem.getEnvironments().isEmpty() ? null : (Environment)oldSystem.getEnvironments().get(0);
            if (this.isInternalEnvironmentAddressChanged(environment, oldEnvironment)) {
                messageHandler.accept(CHAINS_REDEPLOY_NEEDED_MSG);
            }
            if (environment == null && oldEnvironment != null) {
                this.environmentService.deleteEnvironment(newSystem.getId(), oldEnvironment.getId());
            } else if (environment != null && oldEnvironment != null) {
                environment.setId(oldEnvironment.getId());
            }
            this.changeDiscoveredSourceLabels(newSystem, false);
        } else if (IntegrationSystemType.EXTERNAL == newSystem.getIntegrationSystemType()) {
            this.removeDuplicateLabels(newSystem, oldSystem);
            this.mergeEnvironmentsById(newSystem, oldSystem);
            this.setActiveEnvironmentId(newSystem, oldSystem, deployLabel, messageHandler);
        }
        this.mergeNonTechnicalServiceLabels(newSystem, oldSystem);
        return this.mergeSpecificationGroups(newSystem, oldSystem, messageHandler, technicalLabels);
    }

    private void mergeNonTechnicalServiceLabels(IntegrationSystem newSystem, IntegrationSystem oldSystem) {
        if (CollectionUtils.isEmpty((Collection)oldSystem.getLabels())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)newSystem.getLabels())) {
            newSystem.setLabels(oldSystem.getLabels());
            return;
        }
        Set existingLabelNames = oldSystem.getLabels().stream().filter(l -> !l.isTechnical()).map(l -> l.getName()).collect(Collectors.toSet());
        newSystem.getLabels().removeIf(l -> !l.isTechnical() && existingLabelNames.contains(l.getName()));
        newSystem.addLabels((Collection)oldSystem.getLabels().stream().filter(l -> !l.isTechnical()).collect(Collectors.toSet()));
    }

    private void replaceSystemTechnicalLabels(IntegrationSystem newSystem, IntegrationSystem oldSystem, Set<String> technicalLabels) {
        if (!CollectionUtils.isEmpty(technicalLabels)) {
            if (oldSystem != null) {
                newSystem.getLabels().addAll(oldSystem.getLabels().stream().filter(l -> l.isTechnical() && technicalLabels.contains(l.getName())).toList());
            }
            Set<String> technicalLabelsToAdd = technicalLabels.stream().filter(labelName -> newSystem.getLabels().stream().filter(AbstractLabel::isTechnical).noneMatch(l -> l.getName().equals(labelName))).collect(Collectors.toSet());
            technicalLabelsToAdd.forEach(labelName -> newSystem.addLabel(new IntegrationSystemLabel(labelName, newSystem, true)));
        }
        newSystem.getSpecificationGroups().forEach(group -> this.replaceSpecificationGroupTechnicalLabels((SpecificationGroup)group, technicalLabels));
    }

    private void replaceSpecificationGroupTechnicalLabels(SpecificationGroup specificationGroup, Set<String> technicalLabels) {
        if (!CollectionUtils.isEmpty(technicalLabels)) {
            specificationGroup.getLabels().removeIf(label -> label.isTechnical() && !technicalLabels.contains(label.getName()));
            Set currentSystemTechnicalLabels = specificationGroup.getLabels().stream().filter(AbstractLabel::isTechnical).map(AbstractLabel::getName).collect(Collectors.toSet());
            Set<String> technicalLabelsToAdd = technicalLabels.stream().filter(labelName -> !currentSystemTechnicalLabels.contains(labelName)).collect(Collectors.toSet());
            technicalLabelsToAdd.forEach(labelName -> specificationGroup.addLabel(new SpecificationGroupLabel(labelName, specificationGroup, true)));
        } else {
            specificationGroup.getLabels().removeIf(AbstractLabel::isTechnical);
        }
        specificationGroup.getSystemModels().forEach(systemModel -> this.replaceSpecificationTechnicalLabels((SystemModel)systemModel, technicalLabels));
    }

    private void replaceSpecificationTechnicalLabels(SystemModel systemModel, Set<String> technicalLabels) {
        if (!CollectionUtils.isEmpty(technicalLabels)) {
            systemModel.getLabels().removeIf(label -> label.isTechnical() && !technicalLabels.contains(label.getName()));
            Set currentSystemTechnicalLabels = systemModel.getLabels().stream().filter(AbstractLabel::isTechnical).map(AbstractLabel::getName).collect(Collectors.toSet());
            Set<String> technicalLabelsToAdd = technicalLabels.stream().filter(labelName -> !currentSystemTechnicalLabels.contains(labelName)).collect(Collectors.toSet());
            technicalLabelsToAdd.forEach(labelName -> systemModel.addLabel(new SystemModelLabel(labelName, systemModel, true)));
        } else {
            systemModel.getLabels().removeIf(AbstractLabel::isTechnical);
        }
    }

    private Collection<SystemModel> mergeSpecificationGroups(IntegrationSystem newSystem, IntegrationSystem oldSystem, Consumer<String> messageHandler, Set<String> technicalLabels) {
        ArrayList<SystemModel> addedNewModels = new ArrayList<SystemModel>();
        HashMap oldModelsIdFlatMap = new HashMap();
        HashMap<String, SpecificationGroup> oldSpecGroupsIdMap = new HashMap<String, SpecificationGroup>(oldSystem.getSpecificationGroups().size());
        HashMap<String, SpecificationGroup> oldSpecGroupsNameMap = new HashMap<String, SpecificationGroup>(oldSystem.getSpecificationGroups().size());
        for (SpecificationGroup oldGroup : oldSystem.getSpecificationGroups()) {
            oldModelsIdFlatMap.putAll(oldGroup.getSystemModels().stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity())));
            oldSpecGroupsIdMap.put(oldGroup.getId(), oldGroup);
            oldSpecGroupsNameMap.put(oldGroup.getName(), oldGroup);
        }
        Iterator newSpecGroupIterator = newSystem.getSpecificationGroups().iterator();
        while (newSpecGroupIterator.hasNext()) {
            SpecificationGroup newSpecGroup = (SpecificationGroup)newSpecGroupIterator.next();
            SpecificationGroup sameOldSpecGroup = null;
            Map oldSpecGroupModelsNameMap = null;
            if (oldSpecGroupsNameMap.containsKey(newSpecGroup.getName())) {
                if (oldSpecGroupsIdMap.containsKey(newSpecGroup.getId())) {
                    sameOldSpecGroup = (SpecificationGroup)oldSpecGroupsIdMap.get(newSpecGroup.getId());
                    try {
                        oldSpecGroupModelsNameMap = sameOldSpecGroup.getSystemModels().stream().collect(Collectors.toMap(AbstractEntity::getName, Function.identity()));
                    }
                    catch (IllegalStateException exception) {
                        throw new DuplicateKeyException("Specification with not unique name found in specification group " + sameOldSpecGroup.getName(), (Throwable)exception);
                    }
                } else {
                    this.addSuffixToSpecificationGroupName(newSpecGroup, oldSystem, newSystem);
                }
            }
            newSpecGroup.getSystemModels().removeIf(spec -> {
                if (oldModelsIdFlatMap.containsKey(spec.getId())) {
                    messageHandler.accept(SPECIFICATION_EXISTS_BY_ID_ERROR_MESSAGE_START + spec.getId() + "' was not imported. It already exists in this service. ");
                    this.addUniqueSpecificationLabels((SystemModel)oldModelsIdFlatMap.get(spec.getId()), spec.getLabels());
                    return true;
                }
                return false;
            });
            if (sameOldSpecGroup != null) {
                for (SystemModel newSpecGroupModel : newSpecGroup.getSystemModels()) {
                    if (oldSpecGroupModelsNameMap.containsKey(newSpecGroupModel.getName())) {
                        this.addUniqueSpecificationLabels((SystemModel)oldSpecGroupModelsNameMap.get(newSpecGroupModel.getName()), newSpecGroupModel.getLabels());
                        String warnMessage = newSpecGroupModel.isSourcesEquals(((SystemModel)oldSpecGroupModelsNameMap.get(newSpecGroupModel.getName())).getSpecificationSources(), false) ? "It already exists in specification group '" + sameOldSpecGroup.getName() + "'. " : "Specification with same version and different file(s) content already exists. ";
                        messageHandler.accept(SPECIFICATION_EXISTS_ERROR_MESSAGE_START + newSpecGroupModel.getName() + "' from group '" + newSpecGroupModel.getSpecificationGroup().getName() + SPECIFICATION_EXISTS_ERROR_MESSAGE_END + warnMessage);
                        continue;
                    }
                    sameOldSpecGroup.addSystemModel(newSpecGroupModel);
                    addedNewModels.add(newSpecGroupModel);
                }
                this.replaceSpecificationGroupTechnicalLabels(sameOldSpecGroup, technicalLabels);
                this.addUniqueSpecificationGroupLabels(sameOldSpecGroup, newSpecGroup.getLabels());
                newSpecGroupIterator.remove();
                continue;
            }
            addedNewModels.addAll(newSpecGroup.getSystemModels());
        }
        return addedNewModels;
    }

    private void addUniqueSpecificationLabels(SystemModel specification, Set<SystemModelLabel> newLabels) {
        if (CollectionUtils.isEmpty(newLabels)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)specification.getLabels())) {
            specification.setLabels(new HashSet());
        }
        Set existingLabelNames = specification.getLabels().stream().filter(l -> !l.isTechnical()).map(l -> l.getName()).collect(Collectors.toSet());
        newLabels = new HashSet<SystemModelLabel>(newLabels);
        newLabels.removeIf(l -> l.isTechnical() || existingLabelNames.contains(l.getName()));
        specification.addLabels(newLabels);
    }

    private void addUniqueSpecificationGroupLabels(SpecificationGroup specGroup, Set<SpecificationGroupLabel> newLabels) {
        if (CollectionUtils.isEmpty(newLabels)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)specGroup.getLabels())) {
            specGroup.setLabels(new HashSet());
        }
        Set existingLabelNames = specGroup.getLabels().stream().filter(l -> !l.isTechnical()).map(l -> l.getName()).collect(Collectors.toSet());
        newLabels = new HashSet<SpecificationGroupLabel>(newLabels);
        newLabels.removeIf(l -> l.isTechnical() || existingLabelNames.contains(l.getName()));
        specGroup.addLabels(newLabels);
    }

    private void addSuffixToSpecificationGroupName(SpecificationGroup group, IntegrationSystem oldSystem, IntegrationSystem newSystem) {
        int counter = 0;
        String name = null;
        Set existingNames = Stream.of(oldSystem, newSystem).map(IntegrationSystem::getSpecificationGroups).flatMap(Collection::stream).map(AbstractEntity::getName).collect(Collectors.toSet());
        while (Objects.isNull(name) || existingNames.contains(name)) {
            name = String.format("%s (%d)", group.getName(), ++counter);
        }
        group.setName(name);
    }

    private void mergeEnvironmentsById(IntegrationSystem system, IntegrationSystem oldSystem) {
        List environments = system.getEnvironments();
        for (Environment oldEnv : oldSystem.getEnvironments()) {
            if (!environments.stream().noneMatch(newEnv -> newEnv.getId().equals(oldEnv.getId()))) continue;
            environments.add(oldEnv);
        }
    }

    private void changeDiscoveredSourceLabels(IntegrationSystem system, boolean isNewSystem) {
        for (SpecificationGroup specificationGroup : system.getSpecificationGroups()) {
            for (SystemModel systemModel : specificationGroup.getSystemModels()) {
                SystemModelSource modelSourceType = systemModel.getSource();
                if (modelSourceType != null && (!SystemModelSource.DISCOVERED.equals((Object)modelSourceType) || !this.isNotDiscoveredOnThisEnvironment(systemModel, isNewSystem))) continue;
                systemModel.setSource(SystemModelSource.MANUAL);
            }
        }
    }

    private boolean isNotDiscoveredOnThisEnvironment(SystemModel systemModel, boolean isNewSystem) {
        return isNewSystem || this.systemModelService.getSystemModelOrElseNull(systemModel.getId()) == null;
    }

    private boolean isInternalEnvironmentAddressChanged(Environment environment, Environment oldEnvironment) {
        String environmentAddress = environment == null ? "" : StringUtils.defaultString((String)environment.getAddress());
        String oldEnvironmentAddress = oldEnvironment == null ? "" : StringUtils.defaultString((String)oldEnvironment.getAddress());
        return !environmentAddress.equals(oldEnvironmentAddress);
    }

    private void removeDuplicateLabels(IntegrationSystem system, IntegrationSystem oldSystem) {
        List updatedEnvironments = system.getEnvironments();
        for (Environment oldEnvironment : oldSystem.getEnvironments()) {
            if (!updatedEnvironments.stream().noneMatch(e -> e.getId().equals(oldEnvironment.getId()))) continue;
            oldEnvironment.getLabels().removeIf(label -> updatedEnvironments.stream().anyMatch(e -> e.getLabels().contains(label)));
        }
    }

    private void checkSpecificationUniqueness(IntegrationSystem system) {
        if (this.isNotUniqueByName(system.getSpecificationGroups())) {
            throw new DuplicateKeyException("Specification group with not unique name found");
        }
        for (SpecificationGroup specificationGroup : system.getSpecificationGroups()) {
            if (!this.isNotUniqueByName(specificationGroup.getSystemModels())) continue;
            throw new DuplicateKeyException("Specification with not unique version found in specification group " + specificationGroup.getName());
        }
    }

    private boolean isNotUniqueByName(List<? extends AbstractSystemEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return false;
        }
        return entities.size() != entities.stream().map(AbstractEntity::getName).collect(Collectors.toSet()).size();
    }

    private void prepareIntegrationSystemForCreate(IntegrationSystem system, String deployLabel, Consumer<String> messageHandler) {
        this.changeDiscoveredSourceLabels(system, true);
        this.setActiveEnvironmentId(system, deployLabel, messageHandler);
    }

    private void setActiveEnvironmentId(IntegrationSystem system, String deployLabel, Consumer<String> messageHandler) {
        this.setActiveEnvironmentId(system, null, deployLabel, messageHandler);
    }

    private void setActiveEnvironmentId(IntegrationSystem system, IntegrationSystem oldSystem, String deployLabelString, Consumer<String> messageHandler) {
        String environmentIdToActivate = null;
        try {
            if (!StringUtils.isBlank((CharSequence)deployLabelString)) {
                EnvironmentLabel labelToActivate = EnvironmentLabel.valueOf((String)deployLabelString.toUpperCase());
                environmentIdToActivate = system.getEnvironments().stream().filter(env -> env.getLabels().stream().anyMatch(l -> l.equals((Object)labelToActivate))).map(AbstractEntity::getId).findAny().orElse(null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!StringUtils.isBlank(environmentIdToActivate)) {
            system.setActiveEnvironmentId(environmentIdToActivate);
        } else if (oldSystem != null && !StringUtils.isBlank((CharSequence)oldSystem.getActiveEnvironmentId())) {
            system.setActiveEnvironmentId(oldSystem.getActiveEnvironmentId());
        }
    }

    protected SystemDeserializationResult getBaseSystemDeserializationResult(JsonNode serviceNode) throws JsonProcessingException {
        String systemId;
        SystemDeserializationResult result = new SystemDeserializationResult();
        String string = systemId = serviceNode.get("id") != null ? serviceNode.get("id").asText(null) : null;
        if (systemId == null) {
            throw new RuntimeException("Missing id field in system file");
        }
        String systemName = serviceNode.get("name") != null ? serviceNode.get("name").asText("") : "";
        Timestamp modifiedWhen = serviceNode.get("modifiedWhen") != null ? new Timestamp(serviceNode.get("modifiedWhen").asLong()) : null;
        IntegrationSystem baseSystem = new IntegrationSystem();
        baseSystem.setId(systemId);
        baseSystem.setName(systemName);
        baseSystem.setModifiedWhen(modifiedWhen);
        result.setSystem(baseSystem);
        return result;
    }

    protected ObjectNode getFileNode(File file) throws IOException {
        return (ObjectNode)this.yamlMapper.readTree(file);
    }

    public void logSystemExportImport(IntegrationSystem system, String archiveName, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(system != null ? EntityType.getSystemType((IntegrationSystem)system) : EntityType.SERVICES).entityId(system != null ? system.getId() : null).entityName(system != null ? system.getName() : archiveName).operation(operation).build());
    }
}

