/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.instructions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsExternalException;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsInternalException;
import org.qubership.integration.platform.catalog.mapping.exportimport.instructions.CommonVariablesInstructionsMapper;
import org.qubership.integration.platform.catalog.mapping.exportimport.instructions.GeneralInstructionsMapper;
import org.qubership.integration.platform.catalog.mapping.exportimport.instructions.ServiceInstructionsMapper;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.GeneralImportInstructionsConfig;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportEntityType;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionsDTO;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.instructions.ImportInstruction;
import org.qubership.integration.platform.catalog.persistence.configs.repository.instructions.ImportInstructionsRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.catalog.validation.EntityValidator;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ChainsIgnoreOverrideResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.IgnoreResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ImportInstructionResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ImportInstructionStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequestAction;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.SpecificationGroupService;
import org.qubership.integration.platform.runtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.CommonVariablesImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportInstructionsService {
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsService.class);
    public static final String UNIQUE_OVERRIDE_DB_CONSTRAINT_NAME = "import_instructions_unique_override_idx";
    private static final String FAILED_TO_READ_CONFIG_FILE_MESSAGE = "Failed to read import instructions config file: ";
    private final String instructionsFileName;
    private final YAMLMapper yamlMapper;
    private final ImportInstructionsRepository importInstructionsRepository;
    private final GeneralInstructionsMapper generalInstructionsMapper;
    private final ServiceInstructionsMapper serviceInstructionsMapper;
    private final ChainService chainService;
    private final DeploymentService deploymentService;
    private final SystemService systemService;
    private final SpecificationGroupService specificationGroupService;
    private final SystemModelService systemModelService;
    private final CommonVariablesImportService commonVariablesImportService;
    private final CommonVariablesInstructionsMapper commonVariablesInstructionsMapper;
    private final EntityValidator entityValidator;
    private final ActionsLogService actionsLogService;

    @Autowired
    public ImportInstructionsService(@Value(value="${qip.import.instructions-filename:qip-import-instructions}") String instructionsFileName, ImportInstructionsRepository importInstructionsRepository, GeneralInstructionsMapper generalInstructionsMapper, ServiceInstructionsMapper serviceInstructionsMapper, ChainService chainService, DeploymentService deploymentService, SystemService systemService, SpecificationGroupService specificationGroupService, SystemModelService systemModelService, CommonVariablesImportService commonVariablesImportService, CommonVariablesInstructionsMapper commonVariablesInstructionsMapper, EntityValidator entityValidator, ActionsLogService actionsLogService) {
        this.instructionsFileName = instructionsFileName + ".yaml";
        this.yamlMapper = new YAMLMapper().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        this.importInstructionsRepository = importInstructionsRepository;
        this.generalInstructionsMapper = generalInstructionsMapper;
        this.serviceInstructionsMapper = serviceInstructionsMapper;
        this.chainService = chainService;
        this.deploymentService = deploymentService;
        this.systemService = systemService;
        this.specificationGroupService = specificationGroupService;
        this.systemModelService = systemModelService;
        this.commonVariablesImportService = commonVariablesImportService;
        this.commonVariablesInstructionsMapper = commonVariablesInstructionsMapper;
        this.entityValidator = entityValidator;
        this.actionsLogService = actionsLogService;
    }

    public List<ImportInstruction> getCatalogImportInstructions() {
        return this.importInstructionsRepository.findAll();
    }

    public List<ImportInstruction> getAllImportInstructions() {
        ArrayList<ImportInstruction> importInstructions = new ArrayList<ImportInstruction>(this.getCatalogImportInstructions());
        ImportInstructionsDTO variablesInstructionsDTO = this.commonVariablesImportService.getCommonVariablesImportInstructions();
        if (variablesInstructionsDTO != null) {
            importInstructions.addAll(this.commonVariablesInstructionsMapper.asEntities(variablesInstructionsDTO));
        }
        return importInstructions;
    }

    public List<ImportInstruction> getChainImportInstructions(Collection<ImportInstructionAction> actions) {
        return this.importInstructionsRepository.findByEntityTypeAndActionIn(ImportEntityType.CHAIN, actions);
    }

    public List<ImportInstruction> getServiceImportInstructions(Collection<ImportInstructionAction> actions) {
        return this.importInstructionsRepository.findByEntityTypeAndActionIn(ImportEntityType.SERVICE, actions);
    }

    public ImportInstructionsConfig getServiceImportInstructionsConfig(Collection<ImportInstructionAction> actions) {
        return this.serviceInstructionsMapper.asConfig(this.getServiceImportInstructions(actions));
    }

    public List<ImportInstruction> getImportInstructionsForPreview(File importInstructionsConfigFile) {
        GeneralImportInstructionsConfig importInstructionsConfig;
        try {
            importInstructionsConfig = this.parseImportInstructionsConfig(importInstructionsConfigFile.getName(), FileUtils.readFileToByteArray((File)importInstructionsConfigFile));
        }
        catch (IOException e) {
            log.error("Failed to read import instructions config file: {}", (Object)importInstructionsConfigFile, (Object)e);
            throw new ImportInstructionsInternalException(FAILED_TO_READ_CONFIG_FILE_MESSAGE + importInstructionsConfigFile.getName(), (Throwable)e);
        }
        ArrayList<ImportInstruction> importInstructions = new ArrayList<ImportInstruction>(this.generalInstructionsMapper.asEntitiesIncludingDeletes(importInstructionsConfig));
        for (ImportInstruction storedImportInstruction : this.getAllImportInstructions()) {
            if (ImportEntityType.COMMON_VARIABLE == storedImportInstruction.getEntityType()) {
                boolean noInstructionInConfig = importInstructions.stream().noneMatch(importInstruction -> importInstruction.equals((Object)storedImportInstruction) && importInstruction.getEntityType() == ImportEntityType.COMMON_VARIABLE);
                if (!noInstructionInConfig) continue;
                importInstructions.add(storedImportInstruction);
                continue;
            }
            if (importInstructions.contains(storedImportInstruction)) continue;
            importInstructions.add(storedImportInstruction);
        }
        return importInstructions;
    }

    public List<ImportInstruction> saveImportInstructions(GeneralImportInstructionsConfig generalImportInstructionsConfig) {
        return this.importInstructionsRepository.saveAll((Iterable)this.generalInstructionsMapper.asEntities(generalImportInstructionsConfig));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<ImportInstructionResult> uploadImportInstructionsConfig(MultipartFile file, Set<String> labels) {
        try {
            return this.uploadImportInstructionsConfig(file.getOriginalFilename(), file.getBytes(), labels);
        }
        catch (IOException e) {
            log.error("Failed to read import instructions config file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw new ImportInstructionsInternalException(FAILED_TO_READ_CONFIG_FILE_MESSAGE + file.getOriginalFilename(), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<ImportInstructionResult> uploadImportInstructionsConfig(File file, Set<String> labels) {
        try {
            return this.uploadImportInstructionsConfig(file.getName(), FileUtils.readFileToByteArray((File)file), labels);
        }
        catch (IOException e) {
            log.error("Failed to read import instructions config file: {}", (Object)file.getName(), (Object)e);
            throw new ImportInstructionsInternalException(FAILED_TO_READ_CONFIG_FILE_MESSAGE + file.getName(), (Throwable)e);
        }
    }

    public Pair<String, byte[]> exportImportInstructions() {
        GeneralImportInstructionsConfig importInstructionsConfig = this.getAllImportInstructionsConfig();
        try {
            JsonNode instructionsNode = (JsonNode)this.yamlMapper.convertValue((Object)importInstructionsConfig, JsonNode.class);
            StringBuilder importInstructionsYaml = new StringBuilder();
            importInstructionsYaml.append("# all instructions with delete action won't be stored in DB for ANY section below and they will be applied immediately during the file upload\n\n");
            Iterator nodesIterator = instructionsNode.fields();
            while (nodesIterator.hasNext()) {
                Map.Entry nodeEntry = (Map.Entry)nodesIterator.next();
                switch ((String)nodeEntry.getKey()) {
                    case "chains": {
                        importInstructionsYaml.append("# chains section might contain delete, ignore and override actions\n");
                        break;
                    }
                    case "services": {
                        importInstructionsYaml.append("# services section might contain delete and ignore actions\n");
                        break;
                    }
                    case "specificationGroups": {
                        importInstructionsYaml.append("# specification groups section might contain only delete action\n");
                        break;
                    }
                    case "specifications": {
                        importInstructionsYaml.append("# specifications section might contain only delete action\n");
                        break;
                    }
                    case "commonVariables": {
                        importInstructionsYaml.append("# common variables section might contain delete and ignore actions\n");
                    }
                }
                importInstructionsYaml.append(this.yamlMapper.writeValueAsString((Object)nodeEntry));
            }
            Pair exportResult = Pair.of((Object)this.instructionsFileName, (Object)importInstructionsYaml.toString().getBytes());
            this.logAction(this.instructionsFileName, null, EntityType.IMPORT_INSTRUCTIONS, LogOperation.EXPORT);
            return exportResult;
        }
        catch (Exception e) {
            log.error("Error while exporting import instructions", (Throwable)e);
            throw new ImportInstructionsInternalException("Error while exporting import instructions", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ChainsIgnoreOverrideResult performChainIgnoreOverrideInstructions(Collection<String> chainsToImport) {
        ArrayList<ImportInstructionResult> instructionResults = new ArrayList<ImportInstructionResult>();
        List<ImportInstruction> importInstructions = this.getChainImportInstructions(Set.of(ImportInstructionAction.IGNORE, ImportInstructionAction.OVERRIDE));
        Map filteredChainsToImport = chainsToImport.stream().map(chainId -> Pair.of((Object)chainId, (Object)((Object)((ChainCommitRequestAction)null)))).collect(HashMap::new, (map, pair) -> map.put((String)pair.getKey(), (ChainCommitRequestAction)((Object)((Object)pair.getValue()))), HashMap::putAll);
        HashMap<String, String> overridesMapping = new HashMap<String, String>();
        for (ImportInstruction importInstruction : importInstructions) {
            block9: {
                block8: {
                    if (ImportInstructionAction.IGNORE.equals((Object)importInstruction.getAction())) {
                        if (!filteredChainsToImport.containsKey(importInstruction.getId())) continue;
                        filteredChainsToImport.remove(importInstruction.getId());
                        instructionResults.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(importInstruction.getId())).name(importInstruction.getEntityName())).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.IGNORED)).build());
                        continue;
                    }
                    if (chainsToImport.contains(importInstruction.getOverriddenBy())) {
                        try {
                            if (!this.chainService.setOverriddenById(importInstruction.getId(), importInstruction.getOverriddenBy()) && !chainsToImport.contains(importInstruction.getId())) break block8;
                            overridesMapping.put(importInstruction.getOverriddenBy(), importInstruction.getId());
                            this.deploymentService.deleteAllByChainId(importInstruction.getId());
                            log.info("Chain {} overridden by {} as a part of import instructions list", (Object)importInstruction.getId(), (Object)importInstruction.getOverriddenBy());
                            instructionResults.add(this.buildOverriddenInstructionResult(importInstruction));
                        }
                        catch (Exception e) {
                            instructionResults.add(this.handleOverridingException(e, importInstruction));
                            continue;
                        }
                    }
                }
                if (!chainsToImport.contains(importInstruction.getId())) continue;
                if (!chainsToImport.contains(importInstruction.getOverriddenBy())) {
                    try {
                        if (!this.chainService.setOverridesChainId(importInstruction.getId(), importInstruction.getOverriddenBy())) break block9;
                        overridesMapping.put(importInstruction.getOverriddenBy(), importInstruction.getId());
                        instructionResults.add(this.buildOverriddenInstructionResult(importInstruction));
                    }
                    catch (Exception e) {
                        instructionResults.add(this.handleOverridingException(e, importInstruction));
                        continue;
                    }
                }
            }
            filteredChainsToImport.put(importInstruction.getId(), ChainCommitRequestAction.SNAPSHOT);
        }
        return new ChainsIgnoreOverrideResult(filteredChainsToImport, overridesMapping, instructionResults);
    }

    public IgnoreResult performServiceIgnoreInstructions(Collection<String> servicesToImport, boolean includeResults) {
        Map ignoreInstructions = this.getServiceImportInstructions(Set.of(ImportInstructionAction.IGNORE)).stream().collect(Collectors.toMap(ImportInstruction::getId, Function.identity()));
        HashSet<String> serviceIdsToImport = new HashSet<String>();
        ArrayList<ImportInstructionResult> importInstructionResults = new ArrayList<ImportInstructionResult>();
        for (String serviceId : servicesToImport) {
            ImportInstruction ignoreInstruction = (ImportInstruction)ignoreInstructions.get(serviceId);
            if (ignoreInstruction == null) {
                serviceIdsToImport.add(serviceId);
                continue;
            }
            if (!includeResults) continue;
            importInstructionResults.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(ignoreInstruction.getId())).name(ignoreInstruction.getEntityName())).entityType(ImportEntityType.SERVICE)).status(ImportInstructionStatus.IGNORED)).build());
        }
        return new IgnoreResult(serviceIdsToImport, importInstructionResults);
    }

    private GeneralImportInstructionsConfig getAllImportInstructionsConfig() {
        GeneralImportInstructionsConfig importInstructionsConfig = this.generalInstructionsMapper.asConfig(this.importInstructionsRepository.findAll());
        importInstructionsConfig.setCommonVariables(this.commonVariablesImportService.getCommonVariablesImportInstructionsConfig());
        return importInstructionsConfig;
    }

    private List<ImportInstructionResult> uploadImportInstructionsConfig(String fileName, byte[] fileContent, Set<String> labels) {
        GeneralImportInstructionsConfig importInstructionsConfig = this.parseImportInstructionsConfig(fileName, fileContent);
        importInstructionsConfig.setLabels(labels);
        this.entityValidator.validate((Object)importInstructionsConfig);
        this.logAction(fileName, null, EntityType.IMPORT_INSTRUCTIONS, LogOperation.IMPORT);
        ArrayList<ImportInstructionResult> importInstructionResults = new ArrayList<ImportInstructionResult>();
        importInstructionResults.addAll(this.performChainDeleteInstructions(importInstructionsConfig));
        importInstructionResults.addAll(this.performSpecificationDeleteInstructions(importInstructionsConfig));
        importInstructionResults.addAll(this.performSpecificationGroupDeleteInstructions(importInstructionsConfig));
        importInstructionResults.addAll(this.performServiceDeleteInstructions(importInstructionsConfig));
        List<ImportInstruction> savedImportInstructions = this.saveImportInstructions(importInstructionsConfig);
        importInstructionResults.addAll(this.commonVariablesImportService.uploadCommonVariablesImportInstructions(fileName, fileContent, labels));
        savedImportInstructions.forEach(importInstruction -> this.logSingleInstructionAction(importInstruction.getId(), importInstruction.getEntityType(), LogOperation.CREATE_OR_UPDATE));
        log.info("Import instructions file {} successfully uploaded", (Object)fileName);
        return importInstructionResults;
    }

    private GeneralImportInstructionsConfig parseImportInstructionsConfig(String fileName, byte[] fileContent) {
        if (!ExportImportUtils.isYamlFile((String)fileName)) {
            log.error("File {} must have yaml/yml extension", (Object)fileName);
            throw new ImportInstructionsExternalException("File " + fileName + " must have yaml/yml extension");
        }
        try {
            return (GeneralImportInstructionsConfig)this.yamlMapper.readValue(fileContent, GeneralImportInstructionsConfig.class);
        }
        catch (IOException e) {
            log.error("Unable to parse import instructions config file: {}", (Object)fileName, (Object)e);
            throw new ImportInstructionsExternalException("Unable to parse import instructions config file: " + fileName, (Throwable)e);
        }
    }

    private List<ImportInstructionResult> performChainDeleteInstructions(GeneralImportInstructionsConfig instructionsConfig) {
        if (Optional.ofNullable(instructionsConfig.getChains()).map(ImportInstructionsConfig::getDelete).filter(deleteInstructions -> !deleteInstructions.isEmpty()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstructionResult> results = new ArrayList<ImportInstructionResult>();
        for (String chainId : instructionsConfig.getChains().getDelete()) {
            try {
                this.chainService.deleteByIdIfExists(chainId).ifPresentOrElse(chain -> {
                    log.info("Chain {} deleted as a part of import instructions list", (Object)chain.getId());
                    results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(chain.getId())).name(chain.getName())).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.DELETED)).build());
                }, () -> results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(chainId)).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.NO_ACTION)).build()));
            }
            catch (Exception e) {
                log.warn("Failed to delete chain {} as a part of import instructions list", (Object)chainId, (Object)e);
                results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(chainId)).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.ERROR_ON_DELETE)).errorMessage(e.getMessage())).build());
            }
        }
        return results;
    }

    private List<ImportInstructionResult> performServiceDeleteInstructions(GeneralImportInstructionsConfig instructionsConfig) {
        if (Optional.ofNullable(instructionsConfig.getServices()).map(ImportInstructionsConfig::getDelete).filter(deleteInstructions -> !deleteInstructions.isEmpty()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstructionResult> results = new ArrayList<ImportInstructionResult>();
        for (String serviceId : instructionsConfig.getServices().getDelete()) {
            try {
                this.systemService.deleteByIdAndReturnService(serviceId).ifPresentOrElse(integrationSystem -> {
                    log.info("Service {} deleted as a part of import instructions list", (Object)integrationSystem.getId());
                    results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(integrationSystem.getId())).name(integrationSystem.getName())).entityType(ImportEntityType.SERVICE)).status(ImportInstructionStatus.DELETED)).build());
                }, () -> results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(serviceId)).entityType(ImportEntityType.SERVICE)).status(ImportInstructionStatus.NO_ACTION)).build()));
            }
            catch (Exception e) {
                log.warn("Failed to delete service {} as a part of import instructions list", (Object)serviceId, (Object)e);
                results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(serviceId)).entityType(ImportEntityType.SERVICE)).status(ImportInstructionStatus.ERROR_ON_DELETE)).errorMessage(e.getMessage())).build());
            }
        }
        return results;
    }

    private List<ImportInstructionResult> performSpecificationGroupDeleteInstructions(GeneralImportInstructionsConfig instructionsConfig) {
        if (Optional.ofNullable(instructionsConfig.getSpecificationGroups()).map(ImportInstructionsConfig::getDelete).filter(deleteInstructions -> !deleteInstructions.isEmpty()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstructionResult> results = new ArrayList<ImportInstructionResult>();
        for (String specificationGroupId : instructionsConfig.getSpecificationGroups().getDelete()) {
            try {
                this.specificationGroupService.deleteByIdExists(specificationGroupId).ifPresentOrElse(specificationGroup -> {
                    log.info("Specification Group {} deleted as a part of import instructions list", (Object)specificationGroup.getId());
                    results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specificationGroup.getId())).name(specificationGroup.getName())).entityType(ImportEntityType.SPECIFICATION_GROUP)).status(ImportInstructionStatus.DELETED)).build());
                }, () -> results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specificationGroupId)).entityType(ImportEntityType.SPECIFICATION_GROUP)).status(ImportInstructionStatus.NO_ACTION)).build()));
            }
            catch (Exception e) {
                log.warn("Failed to delete specification group {} as a part of import instructions list", (Object)specificationGroupId, (Object)e);
                results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specificationGroupId)).entityType(ImportEntityType.SPECIFICATION_GROUP)).status(ImportInstructionStatus.ERROR_ON_DELETE)).errorMessage(e.getMessage())).build());
            }
        }
        return results;
    }

    private List<ImportInstructionResult> performSpecificationDeleteInstructions(GeneralImportInstructionsConfig instructionsConfig) {
        if (Optional.ofNullable(instructionsConfig.getSpecifications()).map(ImportInstructionsConfig::getDelete).filter(deleteInstructions -> !deleteInstructions.isEmpty()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstructionResult> results = new ArrayList<ImportInstructionResult>();
        for (String specificationId : instructionsConfig.getSpecifications().getDelete()) {
            try {
                this.systemModelService.deleteSystemModelByIdIfExists(specificationId).ifPresentOrElse(specification -> {
                    log.info("Specification {} deleted as a part of import instructions list", (Object)specification.getId());
                    results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specification.getId())).name(specification.getName())).entityType(ImportEntityType.SPECIFICATION)).status(ImportInstructionStatus.DELETED)).build());
                }, () -> results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specificationId)).entityType(ImportEntityType.SPECIFICATION)).status(ImportInstructionStatus.NO_ACTION)).build()));
            }
            catch (Exception e) {
                log.warn("Failed to delete specification {} as a part of import instructions list", (Object)specificationId, (Object)e);
                results.add((ImportInstructionResult)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(specificationId)).entityType(ImportEntityType.SPECIFICATION)).status(ImportInstructionStatus.ERROR_ON_DELETE)).errorMessage(e.getMessage())).build());
            }
        }
        return results;
    }

    private void logSingleInstructionAction(String entityName, ImportEntityType importEntityType, LogOperation logOperation) {
        this.logAction(entityName, importEntityType, EntityType.IMPORT_INSTRUCTION, logOperation);
    }

    private void logAction(String entityName, ImportEntityType importEntityType, EntityType logEntityType, LogOperation logOperation) {
        this.actionsLogService.logAction(ActionLog.builder().entityName(entityName).parentName(importEntityType != null ? importEntityType.name() : null).entityType(logEntityType).operation(logOperation).build());
    }

    private ImportInstructionResult buildOverriddenInstructionResult(ImportInstruction importInstruction) {
        return ((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(importInstruction.getId())).name(importInstruction.getEntityName())).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.OVERRIDDEN)).build();
    }

    private ImportInstructionResult handleOverridingException(Exception e, ImportInstruction importInstruction) {
        log.warn("Error when overriding chain {} by {}", (Object)importInstruction.getId(), (Object)importInstruction.getOverriddenBy());
        return ((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)((ImportInstructionResult.ImportInstructionResultBuilder)ImportInstructionResult.builder().id(importInstruction.getId())).name(importInstruction.getEntityName())).entityType(ImportEntityType.CHAIN)).status(ImportInstructionStatus.ERROR_ON_OVERRIDE)).errorMessage(e.getMessage())).build();
    }

    public String getInstructionsFileName() {
        return this.instructionsFileName;
    }
}

