/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiFunction;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.service.filter.FilterConditionPredicateBuilderFactory;
import org.qubership.integration.platform.runtime.catalog.model.filter.FilterFeature;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ChainAlertFilterSpecificationBuilder {
    private final FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory;

    @Autowired
    public ChainAlertFilterSpecificationBuilder(FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory) {
        this.filterConditionPredicateBuilderFactory = filterConditionPredicateBuilderFactory;
    }

    public Specification<ValidationChainAlert> buildSearch(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::or, true);
    }

    public Specification<ValidationChainAlert> buildFilter(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::and, false);
    }

    public Specification<ValidationChainAlert> build(Collection<FilterRequestDTO> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator, boolean searchMode) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            if (!filters.isEmpty()) {
                Predicate[] predicates = (Predicate[])filters.stream().map(filter -> this.buildPredicate((Root<ValidationChainAlert>)root, criteriaBuilder, (FilterRequestDTO)filter)).toArray(Predicate[]::new);
                return filters.size() > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
            }
            return null;
        };
    }

    private Predicate buildPredicate(Root<ValidationChainAlert> root, CriteriaBuilder criteriaBuilder, FilterRequestDTO filter) {
        BiFunction conditionPredicateBuilder = this.filterConditionPredicateBuilderFactory.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String value = filter.getValue();
        return switch (filter.getFeature()) {
            case FilterFeature.CHAIN_ID -> (Predicate)conditionPredicateBuilder.apply(root.get("chain").get("id"), value);
            case FilterFeature.CHAIN_NAME -> (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "chain").get("name"), value);
            case FilterFeature.ELEMENT_ID -> (Predicate)conditionPredicateBuilder.apply(root.get("element").get("id"), value);
            case FilterFeature.ELEMENT_NAME -> (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "element").get("name"), value);
            case FilterFeature.ELEMENT_TYPE -> (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "element").get("type"), value);
            default -> throw new IllegalStateException("Unexpected filter feature: " + String.valueOf((Object)filter.getFeature()));
        };
    }

    private Join<ValidationChainAlert, ?> getJoin(Root<ValidationChainAlert> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

