/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContainerElementPropertiesVerifier
implements ElementPropertiesVerifier {
    private final LibraryElementsService libraryService;
    private final ElementUtils elementUtils;
    private static final String INNER_ELEMENT_NOT_FOUND_MESSAGE_FORMAT = "Container element '%s' must not be empty.";

    @Autowired
    public ContainerElementPropertiesVerifier(LibraryElementsService libraryService, ElementUtils elementUtils) {
        this.libraryService = libraryService;
        this.elementUtils = elementUtils;
    }

    @Override
    public boolean applicableTo(ChainElement element) {
        return true;
    }

    @Override
    public Collection<VerificationError> verify(ChainElement element) {
        ArrayList<VerificationError> verificationErrors = new ArrayList<VerificationError>();
        if (!this.elementUtils.isMandatoryInnerElementPresent(element)) {
            verificationErrors.add(new VerificationError(String.format(INNER_ELEMENT_NOT_FOUND_MESSAGE_FORMAT, this.extractElementName(element))));
        }
        return verificationErrors;
    }

    private String extractElementName(ChainElement element) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(element.getType());
        if (descriptor != null && CollectionUtils.isNotEmpty((Collection)descriptor.getParentRestriction()) && element.getParent() != null) {
            return element.getParent().getName() + " -> " + element.getName();
        }
        return element.getName();
    }
}

