/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.Collection;
import java.util.Collections;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElementWithMandatoryFieldsVerifier
implements ElementPropertiesVerifier {
    private final ElementUtils elementUtils;

    @Autowired
    public ElementWithMandatoryFieldsVerifier(ElementUtils elementUtils) {
        this.elementUtils = elementUtils;
    }

    @Override
    public boolean applicableTo(ChainElement element) {
        return true;
    }

    @Override
    public Collection<VerificationError> verify(ChainElement element) {
        return this.elementUtils.areMandatoryPropertiesPresent(element) ? Collections.emptyList() : Collections.singletonList(new VerificationError("Required fields not specified"));
    }
}

