/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.BaseRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;

@Schema(description="Deployment request object")
public class DeploymentRequest
extends BaseRequest {
    @Schema(description="Domain which was used to deploy to, usually \"default\"")
    @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid domain format")
    private @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid domain format") String domain;
    @Schema(description="Snapshot id")
    @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid snapshotId format")
    private @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid snapshotId format") String snapshotId;
    @Deprecated
    @Schema(description="Not used")
    private Boolean suspended;

    protected DeploymentRequest(DeploymentRequestBuilder<?, ?> b) {
        super(b);
        this.domain = b.domain;
        this.snapshotId = b.snapshotId;
        this.suspended = b.suspended;
    }

    public static DeploymentRequestBuilder<?, ?> builder() {
        return new DeploymentRequestBuilderImpl();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Deprecated
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    @Deprecated
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public DeploymentRequest() {
    }
}

