/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v3.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.SchemaProperty;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceClientException;
import org.qubership.integration.platform.catalog.mapping.EntityDiffResponseMapper;
import org.qubership.integration.platform.catalog.model.dto.chain.EntityDifferenceResponse;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceRequest;
import org.qubership.integration.platform.catalog.service.difference.EntityDifferenceResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ImportInstructionStatus;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.ImportSession;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.ImportSystemStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportCommitResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportPreviewResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportSessionResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v3.mapper.ImportSessionMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.GeneralImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/v3/import"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="import-controller-v-3", description="Import Controller V3")
public class ImportControllerV3 {
    private static final Logger log = LoggerFactory.getLogger(ImportControllerV3.class);
    public static final String SR_PACKAGE_NAME_HEADER = "X-SR-Package-Name";
    public static final String SR_PACKAGE_VERSION_HEADER = "X-SR-Package-Version";
    public static final String SR_PACKAGE_PART_OF_HEADER = "X-SR-Part-Of";
    private static final String SR_DEFAULT_VALUE = "not implemented";
    private final ObjectMapper objectMapper;
    private final GeneralImportService importService;
    private final ImportSessionMapper importSessionMapper;
    private final EntityDiffResponseMapper entityDiffResponseMapper;

    public ImportControllerV3(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, GeneralImportService importService, ImportSessionMapper importSessionMapper, EntityDiffResponseMapper entityDiffResponseMapper) {
        this.objectMapper = objectMapper;
        this.importService = importService;
        this.importSessionMapper = importSessionMapper;
        this.entityDiffResponseMapper = entityDiffResponseMapper;
    }

    @PostMapping(value={"/preview"})
    @Operation(description="Get preview on what will be imported from file")
    public ResponseEntity<ImportPreviewResponse> preview(@RequestParam(value="file") @Parameter(description="File") MultipartFile file) {
        log.info("Request to preview file: {}", (Object)file.getOriginalFilename());
        ImportPreviewResponse response = this.importService.getImportPreview(file);
        return ResponseEntity.ok((Object)response);
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Import chains and related to them services and variables from an archive file")
    @PostMapping(produces={"application/json"})
    public ResponseEntity<ImportCommitResponse> importFile(@RequestParam(value="file") @Parameter(description="Archive file") MultipartFile file, @RequestParam(name="importRequest", required=false) @Parameter(description="Import request object") String importRequest, @RequestParam(name="validateByHash", required=false, defaultValue="false") @Parameter(description="Check chain hash during import") boolean validateByHash, @RequestHeader(required=false, value="chain-labels") @Parameter(description="List of chain labels that should be added on importing chains") List<String> technicalLabels, @RequestHeader(required=false, value="X-SR-Package-Name") @Parameter(description="Package name samples repository header") String packageName, @RequestHeader(required=false, value="X-SR-Package-Version") @Parameter(description="Package version samples repository header") String packageVersion, @RequestHeader(required=false, value="X-SR-Part-Of") @Parameter(description="Package part of samples repository header") String packagePartOf) {
        ImportRequest importRequestObject;
        log.info("Request to import file: {}", (Object)file.getOriginalFilename());
        technicalLabels = ImportControllerV3.addSamplesRepoTechnicalLabels(technicalLabels, (String[])new String[]{packagePartOf, packageName, packageVersion});
        try {
            importRequestObject = StringUtils.isNotBlank((CharSequence)importRequest) ? (ImportRequest)this.objectMapper.readValue(importRequest, ImportRequest.class) : new ImportRequest();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize importRequest field value: " + importRequest);
        }
        String importId = this.importService.importFileAsync(file, importRequestObject, new HashSet(technicalLabels), validateByHash);
        log.info("File {} imported successfully", (Object)file.getOriginalFilename());
        return ResponseEntity.accepted().body((Object)new ImportCommitResponse(importId));
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Get import status")
    @GetMapping(value={"/{importId}"}, produces={"application/json"})
    public ResponseEntity<ImportSessionResponse> getImportStatus(@PathVariable @Parameter(description="Import id") String importId) {
        ImportSession importSession = this.importService.getImportSession(importId);
        if (importSession == null) {
            return ResponseEntity.notFound().build();
        }
        ImportSessionResponse importSessionResponse = this.importSessionMapper.toImportSessionResponse(importSession);
        HttpStatus responseStatus = HttpStatus.OK;
        if (importSessionResponse.getResult() != null) {
            boolean responseHasErrors;
            ImportResult importResult = importSessionResponse.getResult();
            boolean bl = responseHasErrors = importResult.getChains().stream().anyMatch(chainResult -> ImportEntityStatus.ERROR.equals((Object)chainResult.getStatus())) || importResult.getSystems().stream().anyMatch(systemResult -> ImportSystemStatus.ERROR.equals((Object)systemResult.getStatus())) || importResult.getVariables().stream().anyMatch(variableResult -> ImportEntityStatus.ERROR.equals((Object)variableResult.getStatus())) || importResult.getInstructionsResult().stream().anyMatch(instructionResult -> ImportInstructionStatus.ERROR_ON_DELETE.equals((Object)instructionResult.getStatus()) || ImportInstructionStatus.ERROR_ON_OVERRIDE.equals((Object)instructionResult.getStatus()));
            if (responseHasErrors) {
                responseStatus = HttpStatus.MULTI_STATUS;
            }
        }
        return ResponseEntity.status((HttpStatusCode)responseStatus).body((Object)importSessionResponse);
    }

    @Operation(description="Find differences between the chain stored in the QIP database and the imported one", requestBody=@RequestBody(required=true, content={@Content(mediaType="multipart/form-data", schemaProperties={@SchemaProperty(name="file", schema=@Schema(description="Archive file", requiredMode=Schema.RequiredMode.REQUIRED, example="(binary)")), @SchemaProperty(name="diffRequest", schema=@Schema(description="Chain difference request object", requiredMode=Schema.RequiredMode.REQUIRED, requiredProperties={"leftChainId", "rightChainId"}, example="{\"leftChainId\":\"string\",\"leftSnapshotId\":\"string\",\"rightChainId\":\"string\"}"))})}))
    @PostMapping(value={"/chains/diff"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<EntityDifferenceResponse> difference(@RequestParam(value="file") MultipartFile file, @RequestParam(value="diffRequest") @Parameter(hidden=true) String diffRequest) {
        ChainDifferenceRequest chainDiffRequest;
        try {
            chainDiffRequest = (ChainDifferenceRequest)this.objectMapper.readValue(diffRequest, ChainDifferenceRequest.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize diffRequest field value: " + diffRequest);
        }
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (chainDiffRequest.getLeftChainId() == null) {
            validationMessages.add("The leftChainId must not be null");
        }
        if (chainDiffRequest.getRightChainId() == null) {
            validationMessages.add("The rightChainId must not be null");
        }
        if (!validationMessages.isEmpty()) {
            throw new ChainDifferenceClientException("Diff request validation failed: " + String.valueOf(validationMessages));
        }
        EntityDifferenceResult diffResult = this.importService.compareImportEntities(file, chainDiffRequest);
        return ResponseEntity.ok((Object)this.entityDiffResponseMapper.asResponse(diffResult));
    }

    public static List<String> addSamplesRepoTechnicalLabels(List<String> technicalLabels, String ... labels) {
        ArrayList<String> result = technicalLabels == null ? new ArrayList<String>() : new ArrayList<String>(technicalLabels);
        for (String label : labels) {
            if (!StringUtils.isNotBlank((CharSequence)label) || "not implemented".equals(label)) continue;
            result.add(label);
        }
        return result;
    }
}

