/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ElementBaseService;
import org.qubership.integration.platform.runtime.catalog.service.EnvironmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ElementService
extends ElementBaseService {
    private static final Logger log = LoggerFactory.getLogger(ElementService.class);
    public static final String CONTAINER_TYPE_NAME = "container";
    private static final String GROUP_ID_PROPERTY = "groupId";
    public static final String SWIMLANE_TYPE_NAME = "swimlane";
    protected final EnvironmentService environmentService;
    protected final AuditingHandler auditingHandler;

    @Autowired
    public ElementService(ElementRepository elementRepository, AuditingHandler jpaAuditingHandler, EnvironmentService environmentService) {
        super(elementRepository);
        this.auditingHandler = jpaAuditingHandler;
        this.environmentService = environmentService;
    }

    public ChainElement findById(String id) {
        return (ChainElement)this.elementRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Can't find chain element with id: " + id));
    }

    public Optional<ChainElement> findByIdOptional(String id) {
        return this.elementRepository.findById((Object)id);
    }

    public List<ChainElement> findAllBySnapshotIdAndType(String snapshotId, String type) {
        return this.elementRepository.findAllBySnapshotIdAndType(snapshotId, type);
    }

    public <T extends ChainElement> T findById(String id, Class<T> elementClass) {
        ChainElement element = this.findById(id);
        if (elementClass.isAssignableFrom(element.getClass())) {
            return (T)((ChainElement)elementClass.cast(element));
        }
        return null;
    }

    public ChainElement save(ChainElement element) {
        this.auditingHandler.markModified((Object)element);
        return (ChainElement)this.elementRepository.save((Object)element);
    }

    public void delete(ChainElement element) {
        this.elementRepository.delete((Object)element);
    }

    public void deleteAllByChainId(String chainId) {
        this.elementRepository.deleteAllByChainId(chainId);
    }

    public void deleteAllByChainIdAndFlush(String chainId) {
        this.deleteAllByChainId(chainId);
        this.elementRepository.flush();
    }

    public void fillElementsEnvironment(List<ChainElement> elements) {
        HashMap elementsBySystemId;
        if (log.isDebugEnabled()) {
            log.debug("Fill Elements Environment request accepted {}", elements.stream().map(ChainElement::getOriginalId).collect(Collectors.toList()));
        }
        if ((elementsBySystemId = this.getElementsBySystemId(elements)).isEmpty()) {
            return;
        }
        List environments = this.environmentService.generateSystemEnvironments(elementsBySystemId.keySet());
        this.mergeElementsBySystemIdWithEnvironments(elementsBySystemId, environments);
    }

    public void mergeElementsBySystemIdWithEnvironments(HashMap<String, List<ChainElement>> elementsBySystemId, List<ServiceEnvironment> environments) {
        for (ServiceEnvironment serviceEnvironment : environments) {
            List<ChainElement> elementsToUpdate = elementsBySystemId.get(serviceEnvironment.getSystemId());
            if (elementsToUpdate == null) continue;
            elementsToUpdate.forEach(element -> {
                if (element.getProperties().containsKey(GROUP_ID_PROPERTY)) {
                    serviceEnvironment.getProperties().put(GROUP_ID_PROPERTY, element.getProperties().get(GROUP_ID_PROPERTY));
                }
                element.setEnvironment(serviceEnvironment.clone());
            });
        }
    }

    public HashMap<String, List<ChainElement>> getElementsBySystemId(List<ChainElement> elements) {
        HashMap<String, List<ChainElement>> elementsBySystemId = new HashMap<String, List<ChainElement>>();
        block8: for (ChainElement element : elements) {
            String systemId;
            switch (element.getType()) {
                case "service-call": 
                case "async-api-trigger": 
                case "http-trigger": {
                    systemId = element.getProperties() == null ? null : (String)element.getProperties().get("integrationSystemId");
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (StringUtils.isEmpty((CharSequence)systemId)) continue;
            if (!elementsBySystemId.containsKey(systemId)) {
                elementsBySystemId.put(systemId, new ArrayList());
            }
            elementsBySystemId.get(systemId).add(element);
        }
        return elementsBySystemId;
    }

    public void setActualizedChainElements(List<ChainElement> oldChainElementStates, List<ChainElement> newChainElementStates) {
        this.elementRepository.actualizeCollectionStateWOUpdates((Iterable)this.getAllChildElements(oldChainElementStates), (Iterable)this.getAllChildElements(newChainElementStates));
        this.elementRepository.actualizeCollectionStateWOUpdates((Iterable)this.getAllParentElements(oldChainElementStates), (Iterable)this.getAllParentElements(newChainElementStates));
        this.elementRepository.actualizeCollectionStateOnlyUpdates((Iterable)this.getAllChildElements(oldChainElementStates), (Iterable)this.getAllChildElements(newChainElementStates));
        this.elementRepository.actualizeCollectionStateOnlyUpdates((Iterable)this.getAllParentElements(oldChainElementStates), (Iterable)this.getAllParentElements(newChainElementStates));
    }

    private List<ChainElement> getAllChildElements(List<ChainElement> chainElementList) {
        return chainElementList.stream().flatMap(chainElement -> {
            if (chainElement instanceof ContainerChainElement) {
                ContainerChainElement containerChainElement = (ContainerChainElement)chainElement;
                return this.getAllChildElements(containerChainElement.getElements()).stream();
            }
            if (chainElement instanceof SwimlaneChainElement) {
                SwimlaneChainElement swimlaneChainElement = (SwimlaneChainElement)chainElement;
                return this.getAllChildElements(swimlaneChainElement.getElements()).stream();
            }
            return Stream.of(chainElement);
        }).collect(Collectors.toList());
    }

    private List<ChainElement> getAllParentElements(List<ChainElement> chainElementList) {
        return chainElementList.stream().filter(chainElement -> chainElement instanceof ContainerChainElement || chainElement instanceof SwimlaneChainElement).collect(Collectors.toList());
    }
}

