/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.IntegrationSystemLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.SystemBaseService;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.EnvironmentSetUpException;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemService
extends SystemBaseService {
    private static final Logger log = LoggerFactory.getLogger(SystemService.class);
    public static final String SYSTEM_WITH_ID_NOT_FOUND_MESSAGE = "Can't find system with id: ";
    private final ChainService chainService;

    @Autowired
    public SystemService(SystemRepository systemRepository, ActionsLogService actionsLogger, IntegrationSystemLabelsRepository systemLabelsRepository, @Lazy ChainService chainService) {
        super(systemRepository, actionsLogger, systemLabelsRepository);
        this.chainService = chainService;
    }

    @Transactional
    public List<IntegrationSystem> findSystemsRequiredGatewayRoutes(Collection<String> systemIds) {
        return this.systemRepository.findAllById(systemIds).stream().filter(arg_0 -> this.shouldCallControlPlane(arg_0)).collect(Collectors.toList());
    }

    public Optional<IntegrationSystem> deleteByIdAndReturnService(String systemId) {
        IntegrationSystem system = this.getByIdOrNull(systemId);
        if (system != null) {
            if (this.chainService.isSystemUsedByChain(systemId)) {
                throw new IllegalArgumentException("System used by one or more chains");
            }
            this.systemRepository.delete((Object)system);
            this.logSystemAction(system, LogOperation.DELETE);
            return Optional.of(system);
        }
        return Optional.empty();
    }

    private boolean shouldCallControlPlane(IntegrationSystem system) {
        return StringUtils.isNotEmpty((CharSequence)system.getActiveEnvironmentId()) && IntegrationSystemType.EXTERNAL.equals((Object)system.getIntegrationSystemType()) && (OperationProtocol.HTTP.equals((Object)system.getProtocol()) || OperationProtocol.SOAP.equals((Object)system.getProtocol()) || OperationProtocol.GRAPHQL.equals((Object)system.getProtocol()));
    }

    protected Environment getActiveEnvironment(IntegrationSystem system) {
        return system.getEnvironments() != null ? (Environment)system.getEnvironments().stream().filter(env -> system.getActiveEnvironmentId().equals(env.getId())).findFirst().orElse(null) : null;
    }

    protected String getActiveEnvAddress(Environment environment) throws EnvironmentSetUpException {
        String address;
        String string = address = environment != null ? environment.getAddress() : null;
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            return address;
        }
        throw new EnvironmentSetUpException();
    }

    protected Long getConnectTimeout(Environment activeEnvironment) {
        return activeEnvironment != null && activeEnvironment.getProperties().get("connectTimeout") != null ? activeEnvironment.getProperties().get("connectTimeout").asLong(120000L) : 120000L;
    }

    @Transactional
    public IntegrationSystem findById(String systemId) {
        return (IntegrationSystem)this.systemRepository.findById((Object)systemId).orElseThrow(() -> new EntityNotFoundException(SYSTEM_WITH_ID_NOT_FOUND_MESSAGE + systemId));
    }
}

