package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainRolesDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-02-13T15:45:45+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.6 (Eclipse Adoptium)"
)
@Component
public class ChainRolesMapperImpl implements ChainRolesMapper {

    @Override
    public List<ChainRolesDTO> asChainRolesResponses(List<ChainElement> chainElement) {
        if ( chainElement == null ) {
            return null;
        }

        List<ChainRolesDTO> list = new ArrayList<ChainRolesDTO>( chainElement.size() );
        for ( ChainElement chainElement1 : chainElement ) {
            list.add( asChainRolesResponse( chainElement1 ) );
        }

        return list;
    }

    @Override
    public ChainRolesDTO asChainRolesResponse(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }

        ChainRolesDTO.ChainRolesDTOBuilder chainRolesDTO = ChainRolesDTO.builder();

        chainRolesDTO.elementId( chainElement.getId() );
        chainRolesDTO.elementName( chainElement.getName() );
        Map<String, Object> map = chainElement.getProperties();
        if ( map != null ) {
            chainRolesDTO.properties( new LinkedHashMap<String, Object>( map ) );
        }
        chainRolesDTO.modifiedWhen( MapperUtils.fromTimestamp( chainElement.getModifiedWhen() ) );
        chainRolesDTO.chainId( chainElementChainId( chainElement ) );
        chainRolesDTO.chainName( chainElementChainName( chainElement ) );
        chainRolesDTO.unsavedChanges( chainElementChainUnsavedChanges( chainElement ) );

        return chainRolesDTO.build();
    }

    @Override
    public DeploymentRequest prepareDeploymentRequest(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }

        DeploymentRequest.DeploymentRequestBuilder<?, ?> deploymentRequest = DeploymentRequest.builder();

        deploymentRequest.domain( deployment.getDomain() );
        deploymentRequest.snapshotId( deploymentSnapshotId( deployment ) );
        deploymentRequest.suspended( deployment.isSuspended() );
        deploymentRequest.name( deployment.getName() );

        return deploymentRequest.build();
    }

    @Override
    public List<DeploymentRequest> prepareDeploymentRequest(List<Deployment> deployment) {
        if ( deployment == null ) {
            return null;
        }

        List<DeploymentRequest> list = new ArrayList<DeploymentRequest>( deployment.size() );
        for ( Deployment deployment1 : deployment ) {
            list.add( prepareDeploymentRequest( deployment1 ) );
        }

        return list;
    }

    @Override
    public DeploymentRequest prepareDeploymentRequest(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }

        DeploymentRequest.DeploymentRequestBuilder<?, ?> deploymentRequest = DeploymentRequest.builder();

        deploymentRequest.snapshotId( snapshot.getId() );
        deploymentRequest.name( snapshot.getName() );
        deploymentRequest.description( snapshot.getDescription() );

        deploymentRequest.domain( "default" );

        return deploymentRequest.build();
    }

    private String chainElementChainId(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String chainElementChainName(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if ( chain == null ) {
            return null;
        }
        String name = chain.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private boolean chainElementChainUnsavedChanges(ChainElement chainElement) {
        if ( chainElement == null ) {
            return false;
        }
        Chain chain = chainElement.getChain();
        if ( chain == null ) {
            return false;
        }
        boolean unsavedChanges = chain.isUnsavedChanges();
        return unsavedChanges;
    }

    private String deploymentSnapshotId(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }
        Snapshot snapshot = deployment.getSnapshot();
        if ( snapshot == null ) {
            return null;
        }
        String id = snapshot.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
