package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.SnapshotLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotLabelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-02-13T15:45:45+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.6 (Eclipse Adoptium)"
)
@Component
public class SnapshotMapperImpl implements SnapshotMapper {

    @Autowired
    private UserMapper userMapper;

    @Override
    public SnapshotResponse asResponse(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }

        SnapshotResponse.SnapshotResponseBuilder<?, ?> snapshotResponse = SnapshotResponse.builder();

        snapshotResponse.id( snapshot.getId() );
        snapshotResponse.name( snapshot.getName() );
        snapshotResponse.description( snapshot.getDescription() );
        snapshotResponse.createdWhen( MapperUtils.fromTimestamp( snapshot.getCreatedWhen() ) );
        snapshotResponse.createdBy( userMapper.asDTO( snapshot.getCreatedBy() ) );
        snapshotResponse.modifiedWhen( MapperUtils.fromTimestamp( snapshot.getModifiedWhen() ) );
        snapshotResponse.modifiedBy( userMapper.asDTO( snapshot.getModifiedBy() ) );
        snapshotResponse.xmlDefinition( snapshot.getXmlDefinition() );
        snapshotResponse.labels( snapshotLabelSetToSnapshotLabelDTOList( snapshot.getLabels() ) );

        return snapshotResponse.build();
    }

    @Override
    public List<SnapshotResponse> asResponse(List<Snapshot> snapshots) {
        if ( snapshots == null ) {
            return null;
        }

        List<SnapshotResponse> list = new ArrayList<SnapshotResponse>( snapshots.size() );
        for ( Snapshot snapshot : snapshots ) {
            list.add( asResponse( snapshot ) );
        }

        return list;
    }

    @Override
    public Snapshot asRequest(SnapshotRequest snapshot) {
        if ( snapshot == null ) {
            return null;
        }

        Snapshot.SnapshotBuilder<?, ?> snapshot1 = Snapshot.builder();

        snapshot1.name( snapshot.getName() );
        snapshot1.labels( snapshotLabelDTOListToSnapshotLabelSet( snapshot.getLabels() ) );

        return snapshot1.build();
    }

    @Override
    public SnapshotLabel asLabelRequest(SnapshotLabelDTO snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SnapshotLabel.SnapshotLabelBuilder<?, ?> snapshotLabel1 = SnapshotLabel.builder();

        snapshotLabel1.name( snapshotLabel.getName() );
        if ( snapshotLabel.getTechnical() != null ) {
            snapshotLabel1.technical( snapshotLabel.getTechnical() );
        }

        return snapshotLabel1.build();
    }

    @Override
    public List<SnapshotLabel> asLabelRequests(List<SnapshotLabelDTO> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SnapshotLabel> list = new ArrayList<SnapshotLabel>( snapshotLabel.size() );
        for ( SnapshotLabelDTO snapshotLabelDTO : snapshotLabel ) {
            list.add( asLabelRequest( snapshotLabelDTO ) );
        }

        return list;
    }

    @Override
    public SnapshotLabelDTO asLabelResponse(SnapshotLabel snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SnapshotLabelDTO.SnapshotLabelDTOBuilder snapshotLabelDTO = SnapshotLabelDTO.builder();

        snapshotLabelDTO.name( snapshotLabel.getName() );
        snapshotLabelDTO.technical( snapshotLabel.isTechnical() );

        return snapshotLabelDTO.build();
    }

    @Override
    public List<SnapshotLabelDTO> asLabelResponse(List<SnapshotLabel> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SnapshotLabelDTO> list = new ArrayList<SnapshotLabelDTO>( snapshotLabel.size() );
        for ( SnapshotLabel snapshotLabel1 : snapshotLabel ) {
            list.add( asLabelResponse( snapshotLabel1 ) );
        }

        return list;
    }

    protected List<SnapshotLabelDTO> snapshotLabelSetToSnapshotLabelDTOList(Set<SnapshotLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<SnapshotLabelDTO> list = new ArrayList<SnapshotLabelDTO>( set.size() );
        for ( SnapshotLabel snapshotLabel : set ) {
            list.add( asLabelResponse( snapshotLabel ) );
        }

        return list;
    }

    protected Set<SnapshotLabel> snapshotLabelDTOListToSnapshotLabelSet(List<SnapshotLabelDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<SnapshotLabel> set = new LinkedHashSet<SnapshotLabel>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( SnapshotLabelDTO snapshotLabelDTO : list ) {
            set.add( asLabelRequest( snapshotLabelDTO ) );
        }

        return set;
    }
}
