/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.model.system.exportimport;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSystemObject;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer.ExportableObjectWriterVisitor;

public class ExportedIntegrationSystem
extends ExportedSystemObject {
    private List<ExportedSpecificationGroup> specificationGroups;

    public ExportedIntegrationSystem(String id, ObjectNode objectNode, List<ExportedSpecificationGroup> specificationGroups) {
        super(id, objectNode);
        this.specificationGroups = specificationGroups;
    }

    public void accept(ExportableObjectWriterVisitor visitor, ZipOutputStream zipOut, String entryPath) throws IOException {
        visitor.visit(this, zipOut, entryPath);
        for (ExportedSpecificationGroup exportedSpecificationGroup : this.specificationGroups) {
            exportedSpecificationGroup.accept(visitor, zipOut, entryPath);
        }
    }

    public List<ExportedSpecificationGroup> getSpecificationGroups() {
        return this.specificationGroups;
    }

    public void setSpecificationGroups(List<ExportedSpecificationGroup> specificationGroups) {
        this.specificationGroups = specificationGroups;
    }
}

