/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.persistence.configs.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.io.IOException;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;

@Converter
public class ImportResultConverter
implements AttributeConverter<ImportResult, String> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(ImportResult importResult) {
        try {
            return this.objectMapper.writeValueAsString((Object)importResult);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("ImportResult object cannot be converted to DB column value", e);
        }
    }

    public ImportResult convertToEntityAttribute(String importResultColumnValue) {
        try {
            return (ImportResult)this.objectMapper.readValue(importResultColumnValue, ImportResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Import result value cannot be converted into object: " + importResultColumnValue, e);
        }
    }
}

