/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.Set;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.MaskedFieldRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaskedFieldsService {
    private static final Logger log = LoggerFactory.getLogger(MaskedFieldsService.class);
    private static final String MASKED_FIELD_WITH_ID_NOT_FOUND_MESSAGE = "Can't find masked field with id: ";
    private final MaskedFieldRepository maskedRepository;

    @Autowired
    public MaskedFieldsService(MaskedFieldRepository maskedRepository) {
        this.maskedRepository = maskedRepository;
    }

    public MaskedField findById(String fieldId) {
        return (MaskedField)this.maskedRepository.findById((Object)fieldId).orElseThrow(() -> new EntityNotFoundException(MASKED_FIELD_WITH_ID_NOT_FOUND_MESSAGE + fieldId));
    }

    public MaskedField save(MaskedField maskedField) {
        return (MaskedField)this.maskedRepository.save((Object)maskedField);
    }

    public void deleteAllByChainIdAndFlush(String chainId) {
        this.maskedRepository.deleteAllByChainId(chainId);
        this.maskedRepository.flush();
    }

    public void setActualizedMaskedFields(Set<MaskedField> currentMaskedFieldStates, Set<MaskedField> newMaskedFieldStates) {
        this.maskedRepository.actualizeCollectionState(currentMaskedFieldStates, newMaskedFieldStates);
    }
}

