/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.qubership.integration.platform.catalog.context.RequestIdContext;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.persistence.TransactionHandler;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.SnapshotLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.DependencyRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.SnapshotLabelsRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.runtime.catalog.builder.XmlBuilder;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.repository.SnapshotRepository;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.qubership.integration.platform.runtime.catalog.service.MaskedFieldsService;
import org.qubership.integration.platform.runtime.catalog.service.verification.ElementPropertiesVerificationService;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SnapshotService {
    private static final Logger log = LoggerFactory.getLogger(SnapshotService.class);
    private static final String CONFIGURATION_WITH_ID_NOT_FOUND_MESSAGE = "Can't find configuration with id ";
    private final SnapshotRepository snapshotRepository;
    private final ElementRepository elementRepository;
    private final ElementService elementService;
    private final XmlBuilder xmlBuilder;
    private final ChainService chainService;
    private final DependencyRepository dependencyRepository;
    private final DeploymentService deploymentService;
    private final ActionsLogService actionLogger;
    private final ElementPropertiesVerificationService elementPropertiesVerificationService;
    private final MaskedFieldsService maskedFieldsService;
    private final TransactionHandler transactionHandler;
    private final SnapshotService self;
    private final SnapshotLabelsRepository snapshotLabelsRepository;

    @Autowired
    public SnapshotService(SnapshotRepository snapshotRepository, ElementRepository elementRepository, ElementService elementService, XmlBuilder xmlBuilder, ChainService chainService, DependencyRepository dependencyRepository, @Lazy DeploymentService deploymentService, @Lazy SnapshotService self, ActionsLogService actionLogger, ElementPropertiesVerificationService elementPropertiesVerificationService, MaskedFieldsService maskedFieldsService, TransactionHandler transactionHandler, SnapshotLabelsRepository snapshotLabelsRepository) {
        this.snapshotRepository = snapshotRepository;
        this.elementRepository = elementRepository;
        this.elementService = elementService;
        this.xmlBuilder = xmlBuilder;
        this.chainService = chainService;
        this.dependencyRepository = dependencyRepository;
        this.deploymentService = deploymentService;
        this.actionLogger = actionLogger;
        this.elementPropertiesVerificationService = elementPropertiesVerificationService;
        this.maskedFieldsService = maskedFieldsService;
        this.transactionHandler = transactionHandler;
        this.self = self;
        this.snapshotLabelsRepository = snapshotLabelsRepository;
    }

    public Snapshot findById(String snapshotId) {
        return (Snapshot)this.snapshotRepository.findById((Object)snapshotId).orElseThrow(() -> new EntityNotFoundException(CONFIGURATION_WITH_ID_NOT_FOUND_MESSAGE + snapshotId));
    }

    public Map<String, Snapshot> findLastCreatedOrBuild(Collection<String> chainIds, BiConsumer<String, String> errorHandler) {
        Map<String, Snapshot> snapshots = this.snapshotRepository.findAllLastCreated(chainIds).stream().collect(Collectors.toMap(snapshot -> snapshot.getChain().getId(), Function.identity()));
        HashSet<String> chainsWithoutSnapshot = new HashSet<String>(chainIds);
        chainsWithoutSnapshot.removeAll(snapshots.keySet());
        snapshots.putAll(this.buildAll(chainsWithoutSnapshot, errorHandler));
        return snapshots;
    }

    public Optional<Snapshot> tryFindById(String snapshotId) {
        return this.snapshotRepository.findById((Object)snapshotId);
    }

    public List<Snapshot> findByChainIdLight(String chainId) {
        return this.snapshotRepository.findAllByChainId(chainId);
    }

    public Map<String, Snapshot> buildAll(Collection<String> chainIds, BiConsumer<String, String> errorHandler) {
        HashMap<String, Snapshot> result = new HashMap<String, Snapshot>();
        for (String chainId : chainIds) {
            try {
                result.put(chainId, this.self.build(chainId));
            }
            catch (Exception e) {
                log.warn("Failed to build snapshot for chainId {}: {}", (Object)chainId, (Object)e.getMessage());
                errorHandler.accept(chainId, e.getMessage());
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Snapshot build(String chainId) {
        return this.build(chainId, null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Snapshot build(String chainId, Set<String> technicalLabels) {
        Chain chain = this.chainService.findById(chainId);
        this.verifyElementProperties(chain);
        String name = this.snapshotRepository.getNextAvailableName(chainId);
        Snapshot snapshot = ((Snapshot.SnapshotBuilder)Snapshot.builder().name(name)).chain(chain).build();
        if (CollectionUtils.isNotEmpty(technicalLabels)) {
            snapshot.addLabels(this.getSnapshotTechnicalLabels(technicalLabels, snapshot));
        }
        snapshot = (Snapshot)this.snapshotRepository.saveAndFlush((Object)snapshot);
        this.moveElementsToSnapshot(chain, snapshot);
        this.moveMaskedFields(chain.getMaskedFields(), snapshot);
        List snapshotElements = snapshot.getElements();
        this.fillServiceEnvironments(snapshotElements);
        try {
            snapshot.setXmlDefinition(this.xmlBuilder.build(snapshotElements));
        }
        catch (Exception e) {
            log.error("Failed to build xml configuration: {}", (Object)e.getMessage());
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Failed to build xml configuration", e);
        }
        this.chainService.setCurrentSnapshot(chain.getId(), snapshot);
        this.logSnapshotAction(snapshot, chain, LogOperation.CREATE);
        return snapshot;
    }

    private Collection<SnapshotLabel> getSnapshotTechnicalLabels(Set<String> technicalLabels, Snapshot snapshot) {
        ArrayList<SnapshotLabel> snapshotLabels = new ArrayList<SnapshotLabel>();
        for (String labelName : technicalLabels) {
            snapshotLabels.add(new SnapshotLabel(labelName, snapshot, true));
        }
        return snapshotLabels;
    }

    private void fillServiceEnvironments(List<ChainElement> newElements) {
        this.elementService.fillElementsEnvironment(newElements);
        this.elementRepository.saveAll(newElements);
    }

    private void verifyElementProperties(Chain chain) {
        Map errorMap = this.elementPropertiesVerificationService.verifyElementProperties(chain);
        if (!errorMap.isEmpty()) {
            errorMap.forEach((element, errors) -> errors.forEach(error -> log.error("Chain '{}' ({}), element '{}' ({}) properties verification error: {}", new Object[]{chain.getName(), chain.getId(), element.getName(), element.getId(), error.message()})));
            Map.Entry entry = errorMap.entrySet().iterator().next();
            ChainElement element2 = (ChainElement)entry.getKey();
            String message = ((Collection)entry.getValue()).stream().findFirst().map(VerificationError::message).orElse("");
            throw new SnapshotCreationException(message, element2);
        }
    }

    public Snapshot revert(String chainId, String snapshotId) {
        this.elementService.deleteAllByChainIdAndFlush(chainId);
        this.maskedFieldsService.deleteAllByChainIdAndFlush(chainId);
        Chain chain = this.chainService.findById(chainId);
        Snapshot snapshot = this.findById(snapshotId);
        this.revertElements(snapshot, chain);
        this.revertMaskedFields(snapshot.getMaskedFields(), chain);
        chain.setCurrentSnapshot(snapshot);
        chain.setUnsavedChanges(false);
        this.logSnapshotAction(snapshot, chain, LogOperation.REVERT);
        return snapshot;
    }

    private void revertElements(Snapshot snapshot, Chain chain) {
        HashMap<ChainElement, ChainElement> replacements = new HashMap<ChainElement, ChainElement>();
        for (ChainElement element : snapshot.getElements()) {
            ChainElement newElement = element.copy();
            newElement.setId(element.getOriginalId());
            newElement.setOriginalId(null);
            newElement.setSnapshot(null);
            newElement = (ChainElement)this.elementRepository.save((Object)newElement);
            chain.addElement(newElement);
            replacements.put(element, newElement);
        }
        chain.setDefaultSwimlane((SwimlaneChainElement)replacements.get(snapshot.getDefaultSwimlane()));
        chain.setReuseSwimlane((SwimlaneChainElement)replacements.get(snapshot.getReuseSwimlane()));
        this.replaceChildren(replacements);
        this.replaceDependencies(replacements);
    }

    private void revertMaskedFields(Set<MaskedField> maskedFields, Chain chain) {
        for (MaskedField maskedField : maskedFields) {
            MaskedField copiedMaskedField = maskedField.copy();
            copiedMaskedField.setChain(chain);
            copiedMaskedField = this.maskedFieldsService.save(copiedMaskedField);
            chain.addMaskedField(copiedMaskedField);
        }
    }

    private void moveMaskedFields(Set<MaskedField> maskedFields, Snapshot snapshot) {
        for (MaskedField maskedField : maskedFields) {
            MaskedField copiedMaskedField = maskedField.copy();
            copiedMaskedField.setSnapshot(snapshot);
            copiedMaskedField = this.maskedFieldsService.save(copiedMaskedField);
            snapshot.addMaskedField(copiedMaskedField);
        }
    }

    private void moveElementsToSnapshot(@NonNull Chain chain, Snapshot snapshot) {
        Map replacements = this.copyElements(new ArrayList(chain.getElements()), null, snapshot);
        Object v = replacements.get(chain.getDefaultSwimlane());
        if (v instanceof SwimlaneChainElement) {
            SwimlaneChainElement defaultSwimalne = (SwimlaneChainElement)v;
            snapshot.setDefaultSwimlane(defaultSwimalne);
        }
        if ((v = replacements.get(chain.getReuseSwimlane())) instanceof SwimlaneChainElement) {
            SwimlaneChainElement reuseSwimlane = (SwimlaneChainElement)v;
            snapshot.setReuseSwimlane(reuseSwimlane);
        }
        this.replaceChildren(replacements);
        this.replaceDependencies(replacements);
    }

    private Map<ChainElement, ChainElement> copyElements(List<ChainElement> elements, @Nullable Chain chain, Snapshot snapshot) {
        HashMap<ChainElement, ChainElement> replacements = new HashMap<ChainElement, ChainElement>();
        for (ChainElement element : elements) {
            ChainElement newElement = element.copy();
            newElement.setSnapshot(snapshot);
            newElement.setChain(chain);
            newElement = (ChainElement)this.elementRepository.save((Object)newElement);
            if (snapshot != null) {
                snapshot.addElement(newElement);
            }
            if (chain != null) {
                chain.addElement(newElement);
            }
            replacements.put(element, newElement);
        }
        return replacements;
    }

    private void replaceChildren(Map<ChainElement, ChainElement> replacements) {
        for (Map.Entry<ChainElement, ChainElement> entry : replacements.entrySet()) {
            SwimlaneChainElement elementSwimlane;
            ChainElement element = entry.getKey();
            ChainElement newElement = entry.getValue();
            if (element instanceof ContainerChainElement) {
                ContainerChainElement container = (ContainerChainElement)element;
                ContainerChainElement newContainer = (ContainerChainElement)newElement;
                for (ChainElement child : container.getElements()) {
                    ChainElement newChild = replacements.get(child);
                    newContainer.addChildElement(newChild);
                }
            }
            if ((elementSwimlane = element.getSwimlane()) == null) continue;
            SwimlaneChainElement newElementSwimlane = (SwimlaneChainElement)replacements.get(elementSwimlane);
            newElementSwimlane.addElement(newElement);
        }
    }

    private void replaceDependencies(Map<ChainElement, ChainElement> replacements) {
        HashMap<String, Dependency> dependencyReplacements = new HashMap<String, Dependency>();
        for (Map.Entry<ChainElement, ChainElement> entry : replacements.entrySet()) {
            ChainElement element = entry.getKey();
            ChainElement newElement = entry.getValue();
            for (Dependency dependency : element.getInputDependencies()) {
                if (!dependencyReplacements.containsKey(dependency.getId())) {
                    dependencyReplacements.put(dependency.getId(), this.createDependency(replacements.get(dependency.getElementFrom()), replacements.get(dependency.getElementTo())));
                }
                newElement.addInputDependency((Dependency)dependencyReplacements.get(dependency.getId()));
            }
            for (Dependency dependency : element.getOutputDependencies()) {
                if (!dependencyReplacements.containsKey(dependency.getId())) {
                    dependencyReplacements.put(dependency.getId(), this.createDependency(replacements.get(dependency.getElementFrom()), replacements.get(dependency.getElementTo())));
                }
                newElement.addOutputDependency((Dependency)dependencyReplacements.get(dependency.getId()));
            }
        }
    }

    private Dependency createDependency(ChainElement from, ChainElement to) {
        return (Dependency)this.dependencyRepository.save((Object)Dependency.of((ChainElement)from, (ChainElement)to));
    }

    public void deleteAllByChainId(String chainId) {
        List snapshots = this.findByChainIdLight(chainId);
        this.deploymentService.deleteAllByChainId(chainId);
        this.chainService.clearCurrentSnapshot(chainId);
        this.snapshotRepository.deleteAllByChainId(chainId);
        snapshots.forEach(snapshot -> this.logSnapshotAction(snapshot, snapshot.getChain(), LogOperation.DELETE));
    }

    public void deleteById(String snapshotId) {
        this.deploymentService.deleteAllBySnapshotId(snapshotId);
        Snapshot snapshot = this.findById(snapshotId);
        Chain chain = snapshot.getChain();
        if (chain.getCurrentSnapshot() != null) {
            if (chain.getCurrentSnapshot().getId().equals(snapshotId)) {
                this.chainService.clearCurrentSnapshot(chain.getId());
            }
            if (snapshot.getChain().getCurrentSnapshot().getId().equals(snapshotId)) {
                this.chainService.clearCurrentSnapshot(snapshot.getChain().getId());
            }
        }
        this.snapshotRepository.deleteById((Object)snapshotId);
        this.logSnapshotAction(snapshot, chain, LogOperation.DELETE);
    }

    public Snapshot merge(String chainId, String snapshotId, Snapshot request) {
        Snapshot snapshot = this.findById(snapshotId);
        if (snapshot == null) {
            snapshot = this.build(chainId);
        }
        snapshot.setName(request.getName());
        this.replaceLabels(snapshot, request.getLabels());
        snapshot = (Snapshot)this.snapshotRepository.save((Object)snapshot);
        this.logSnapshotAction(snapshot, snapshot.getChain(), LogOperation.UPDATE);
        return snapshot;
    }

    private void replaceLabels(Snapshot snapshot, Set<SnapshotLabel> newLabels) {
        if (newLabels == null) {
            newLabels = Collections.emptySet();
        }
        Set<SnapshotLabel> finalNewLabels = newLabels;
        Snapshot finalSnapshot = snapshot;
        finalNewLabels.forEach(label -> label.setSnapshot(snapshot));
        snapshot.getLabels().removeIf(l -> !l.isTechnical() && !finalNewLabels.stream().map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        finalNewLabels.removeIf(l -> l.isTechnical() || finalSnapshot.getLabels().stream().filter(lab -> !lab.isTechnical()).map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        snapshot.addLabels(newLabels);
    }

    private void logSnapshotAction(Snapshot snapshot, Chain chain, LogOperation operation) {
        this.logSnapshotAction(snapshot.getId(), snapshot.getName(), chain.getId(), chain.getName(), operation);
    }

    private void logSnapshotAction(String snapshotId, String snapshotName, String chainId, String chainName, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SNAPSHOT).entityId(snapshotId).entityName(snapshotName).parentType(chainId == null ? null : EntityType.CHAIN).parentId(chainId).parentName(chainName).operation(operation).build());
    }

    public void pruneSnapshotsAsync(int olderThanDays, int chunk) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SNAPSHOT_CLEANUP).operation(LogOperation.EXECUTE).build());
        String requestId = RequestIdContext.get();
        CompletableFuture.runAsync(() -> {
            RequestIdContext.set((String)requestId);
            this.pruneSnapshots(olderThanDays, chunk);
        }).whenCompleteAsync((ignored, throwable) -> {
            RequestIdContext.set((String)requestId);
            if (throwable != null) {
                log.error("Exception during snapshot cleanup", throwable);
            }
        });
    }

    private void pruneSnapshots(int olderThanDays, int chunk) {
        int deletedCurrent;
        long deletedTotal = 0L;
        long startTime = System.currentTimeMillis();
        Timestamp deletionDate = Timestamp.from(Instant.now().minus(Period.ofDays(olderThanDays)));
        do {
            deletedCurrent = (Integer)this.transactionHandler.supplyInNewTransaction(() -> {
                List result = this.snapshotRepository.pruneByCreatedWhen(deletionDate, chunk);
                result.forEach(s -> this.logSnapshotAction((String)s.get("id"), (String)s.get("name"), (String)s.get("chain"), (String)this.chainService.tryFindById((String)s.get("chain")).map(AbstractEntity::getName).orElse(null), LogOperation.DELETE));
                return result.size();
            });
            deletedTotal += (long)deletedCurrent;
            if (deletedCurrent <= 0) continue;
            log.debug("Snapshots chunk of {} removed, currently removed {}", (Object)deletedCurrent, (Object)deletedTotal);
        } while (deletedCurrent > 0);
        String durationStr = DurationFormatUtils.formatDurationWords((long)(System.currentTimeMillis() - startTime), (boolean)true, (boolean)false);
        log.info("Snapshots removed successfully: {}. Time elapsed: {}", (Object)deletedTotal, (Object)durationStr);
    }
}

