/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.util;

import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EngineDomainUtils {
    private final String DASH_VERSION_REGEX = "-v\\d+$";
    private final Pattern DEFAULT_VERSIONED_DOMAIN_PATTERN;
    @Value(value="${qip.domain.default}")
    private String engineDefaultDomain;

    @Autowired
    public EngineDomainUtils(@Value(value="${qip.internal-services.engine}") String engineNamePrefix) {
        this.DEFAULT_VERSIONED_DOMAIN_PATTERN = Pattern.compile("^" + engineNamePrefix + "-v\\d+$");
    }

    public String convertKubeDeploymentToDomainName(String deploymentName) {
        boolean isDefault = this.DEFAULT_VERSIONED_DOMAIN_PATTERN.matcher(deploymentName).find();
        return isDefault ? this.engineDefaultDomain : deploymentName.replaceFirst("-v\\d+$", "");
    }
}

