/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
@Schema(description = "Import status")
public class ImportSessionResponse {

    @Schema(description = "Import result (if it is available)")
    private ImportResult result;
    @Schema(description = "Completion percent")
    private int completion;
    @Schema(description = "Whether import is done")
    private boolean done;
    @Schema(description = "Error message (if any)")
    private String error;
}
