/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.builder.templates.helpers.BaseHelper;

@TemplatesHelper(value="children")
public class ChildrenHelper
extends BaseHelper
implements Helper<String> {
    public static final String SORT_PROP = "comparison-key-property";

    public Object apply(String childrenName, Options options) throws IOException {
        ContainerChainElement container = (ContainerChainElement)options.context.model();
        if (container != null) {
            List<ChainElement> children = this.findChildrenByType(container, childrenName, (String)options.hash.get(SORT_PROP));
            return this.putCollectionAsContext(children, options);
        }
        return options.inverse();
    }

    private List<ChainElement> findChildrenByType(ContainerChainElement container, String name, String comparisonKeyProperty) {
        return container.getElements().stream().filter(nextChild -> name.equals(nextChild.getType())).sorted(Comparator.comparing(value -> {
            try {
                return Integer.parseInt(value.getProperties().getOrDefault(comparisonKeyProperty, "0").toString());
            }
            catch (Exception e) {
                return 0;
            }
        })).collect(Collectors.toList());
    }
}

