/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Options;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@TemplatesHelper
public class ManualQueryParamsHelper {
    private static final Logger log = LoggerFactory.getLogger(ManualQueryParamsHelper.class);
    private static final Set<String> EXCLUDED_PROPS = Set.of("reuseEstablishedConnection");
    private static final String JSON_ERROR_MESSAGE = "Error while processing a JSON ";
    private static final String JSON_QUERY_PARAMETERS = "jsonQueryParameters";
    private static final String QUERY_PREFIX = "?";
    private static final String QUERY_DELIMITER = "&";
    private static final String QUERY_SUFFIX = "";
    private static final String KEY_VALUE_DELIMITER = "=";
    private final ObjectMapper objectMapper;

    @Autowired
    public ManualQueryParamsHelper(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CharSequence manualQuery(Options options) {
        Map hash = options.hash;
        StringJoiner queryJoiner = new StringJoiner(QUERY_DELIMITER, QUERY_PREFIX, QUERY_SUFFIX);
        boolean atLeastOneProperty = false;
        for (Map.Entry entry : hash.entrySet()) {
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            if (((String)entry.getKey()).equals(JSON_QUERY_PARAMETERS)) {
                try {
                    Map jsonNode = (Map)this.objectMapper.readValue(entry.getValue().toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    for (Map.Entry jsonEntry : jsonNode.entrySet()) {
                        atLeastOneProperty = true;
                        String key = (String)jsonEntry.getKey();
                        if (EXCLUDED_PROPS.contains(key)) continue;
                        queryJoiner.add(key + KEY_VALUE_DELIMITER + jsonEntry.getValue().toString());
                    }
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to process query JSON parameters", e);
                }
            }
            atLeastOneProperty = true;
            queryJoiner.add((String)entry.getKey() + KEY_VALUE_DELIMITER + String.valueOf(entry.getValue()));
        }
        return atLeastOneProperty ? queryJoiner.toString() : QUERY_SUFFIX;
    }
}

