/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.EventActionType;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubeDeployment;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubePod;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.DomainResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.EngineResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.EngineUpdateResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.EngineMapper;
import org.springframework.stereotype.Component;

@Component
public class EngineMapperImpl
implements EngineMapper {
    @Override
    public DomainResponse asDomainResponse(KubeDeployment domain) {
        if (domain == null) {
            return null;
        }
        DomainResponse domainResponse = new DomainResponse();
        domainResponse.setId(domain.getName());
        domainResponse.setName(domain.getName());
        domainResponse.setReplicas(domain.getReplicas());
        domainResponse.setNamespace(domain.getNamespace());
        domainResponse.setVersion(domain.getVersion());
        return domainResponse;
    }

    @Override
    public List<DomainResponse> asDomainResponses(List<KubeDeployment> domains) {
        if (domains == null) {
            return null;
        }
        ArrayList<DomainResponse> list = new ArrayList<DomainResponse>(domains.size());
        for (KubeDeployment kubeDeployment : domains) {
            list.add(this.asDomainResponse(kubeDeployment));
        }
        return list;
    }

    @Override
    public EngineResponse asEngineResponse(KubePod pod) {
        if (pod == null) {
            return null;
        }
        EngineResponse.EngineResponseBuilder<?, ?> engineResponse = EngineResponse.builder();
        engineResponse.id(pod.getIp());
        engineResponse.host(pod.getIp());
        engineResponse.name(pod.getName());
        engineResponse.runningStatus(pod.getRunningStatus());
        engineResponse.ready(pod.isReady());
        engineResponse.namespace(pod.getNamespace());
        return engineResponse.build();
    }

    @Override
    public List<EngineResponse> asEngineResponses(List<KubePod> pods) {
        if (pods == null) {
            return null;
        }
        ArrayList<EngineResponse> list = new ArrayList<EngineResponse>(pods.size());
        for (KubePod kubePod : pods) {
            list.add(this.asEngineResponse(kubePod));
        }
        return list;
    }

    @Override
    public EngineUpdateResponse asEngineUpdate(KubePod pod, String domain, EventActionType actionType) {
        if (pod == null && domain == null && actionType == null) {
            return null;
        }
        EngineUpdateResponse.EngineUpdateResponseBuilder<?, ?> engineUpdateResponse = EngineUpdateResponse.builder();
        if (pod != null) {
            engineUpdateResponse.id(pod.getIp());
            engineUpdateResponse.ready(pod.isReady());
            engineUpdateResponse.name(pod.getName());
            engineUpdateResponse.host(pod.getIp());
            engineUpdateResponse.runningStatus(pod.getRunningStatus());
            engineUpdateResponse.namespace(pod.getNamespace());
        }
        if (domain != null) {
            engineUpdateResponse.domainId(domain);
            engineUpdateResponse.domainName(domain);
        }
        engineUpdateResponse.actionType(actionType);
        return engineUpdateResponse.build();
    }
}

