/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainCall2PropertiesBuilder
implements ElementPropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(ChainCall2PropertiesBuilder.class);
    private final ElementService elementService;

    @Autowired
    public ChainCall2PropertiesBuilder(ElementService elementService) {
        this.elementService = elementService;
    }

    @Override
    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "chain-call-2".equals(type);
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        return ChainCall2PropertiesBuilder.getChainCallProperties(this.elementService, element.getProperties());
    }

    public static Map<String, String> getChainCallProperties(ElementService elementService, Map<String, Object> chainCallPropertiesContainer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Optional<ChainElement> originalElement = elementService.findByIdOptional(chainCallPropertiesContainer.getOrDefault("elementId", "").toString());
        originalElement.ifPresent(chainElement -> properties.put("actualElementChainId", chainElement.getChain().getId()));
        return properties;
    }
}

