/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.springframework.stereotype.Component;

@Component
public class CommonPropertiesBuilder
implements ElementPropertiesBuilder {
    @Override
    public boolean applicableTo(ChainElement element) {
        return true;
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("elementName", element.getName());
        properties.put("elementType", element.getType());
        properties.put("elementId", element.getOriginalId());
        if (this.isAsyncSplitElement(element)) {
            properties.put("wireTapId", this.getWireTapId(element));
        }
        return properties;
    }

    public String getWireTapId(ChainElement element) {
        return element.getInputDependencies().stream().map(dependency -> dependency.getElementFrom().getId()).collect(Collectors.joining(","));
    }

    public boolean isAsyncSplitElement(ChainElement element) {
        for (Dependency dependency : element.getInputDependencies()) {
            ChainElement previousElement = dependency.getElementFrom();
            if (!"async-split-element".equals(previousElement.getType())) continue;
            return true;
        }
        return false;
    }
}

