/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.springframework.util.CollectionUtils;

@TemplatesHelper
public class GenerateURLHelper {
    private static final String CHECK_REQUIRED_FIELDS_FOR_ELEMENT = "Check required fields for element.";

    public CharSequence integeratePathAndQueryParams(ChainElement element) {
        String oldFormatUrl = this.getOldFormatUrl(element);
        if (!StringUtils.isBlank((CharSequence)oldFormatUrl)) {
            return oldFormatUrl;
        }
        return this.generatePathParamString(element) + this.generateQueryParamString(element);
    }

    private String getOldFormatUrl(ChainElement element) {
        String baseURL = element.getPropertyAsString("integrationOperationPath");
        LinkedHashMap pathMap = (LinkedHashMap)element.getProperty("integrationOperationPathParameters");
        LinkedHashMap queryMap = (LinkedHashMap)element.getProperty("integrationOperationQueryParameters");
        if (CollectionUtils.isEmpty((Map)pathMap) && CollectionUtils.isEmpty((Map)queryMap)) {
            return null;
        }
        if (pathMap != null) {
            for (String key : pathMap.keySet()) {
                if (StringUtils.isEmpty((CharSequence)((CharSequence)pathMap.get(key))) || baseURL.contains((CharSequence)pathMap.get(key))) continue;
                return null;
            }
        }
        if (queryMap != null) {
            for (String key : queryMap.keySet()) {
                if (StringUtils.isEmpty((CharSequence)((CharSequence)queryMap.get(key))) || baseURL.contains(String.format("%s=%s", key, queryMap.get(key)))) continue;
                return null;
            }
        }
        return baseURL;
    }

    private String generatePathParamString(ChainElement element) {
        LinkedHashMap map;
        String baseURL = element.getPropertyAsString("integrationOperationPath");
        if (baseURL == null) {
            baseURL = "";
        }
        if ((map = (LinkedHashMap)element.getProperty("integrationOperationPathParameters")) == null || map.isEmpty()) {
            return baseURL;
        }
        for (String key : map.keySet()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)map.get(key)))) {
                throw new SnapshotCreationException(CHECK_REQUIRED_FIELDS_FOR_ELEMENT, element);
            }
            baseURL = baseURL.replace("{" + key + "}", (CharSequence)map.get(key));
        }
        return baseURL;
    }

    private String generateQueryParamString(ChainElement element) {
        StringBuilder result = new StringBuilder();
        LinkedHashMap map = (LinkedHashMap)element.getProperty("integrationOperationQueryParameters");
        if (map == null || map.isEmpty()) {
            return result.toString();
        }
        for (String key : map.keySet()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)map.get(key)))) continue;
            if (result.length() == 0) {
                result.append("?");
            } else {
                result.append("&");
            }
            result.append(key).append("=").append((String)map.get(key));
        }
        return result.toString();
    }
}

