/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.EventsUpdate;
import org.qubership.integration.platform.runtime.catalog.service.EventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/events"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="event-controller", description="Event Controller")
public class EventController {
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    private final EventService eventService;

    @Autowired
    public EventController(EventService eventService) {
        this.eventService = eventService;
    }

    @GetMapping
    @Operation(description="Get events update")
    public ResponseEntity<EventsUpdate> getEvents(@RequestParam(required=false, defaultValue="") @Parameter(description="Response will include all events after specified one") String lastEventId) {
        return ResponseEntity.ok((Object)this.eventService.getEvents(lastEventId));
    }
}

