/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/maintenance"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="maintenance-controller", description="Maintenance Controller")
public class MaintenanceController {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceController.class);
    private final SnapshotService snapshotService;

    public MaintenanceController(SnapshotService snapshotService) {
        this.snapshotService = snapshotService;
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Delete old snapshots from all chains")
    @PostMapping(value={"/snapshots/prune"})
    public ResponseEntity<Void> pruneSnapshots(@RequestParam @Valid @Min(value=0L) @Parameter(description="Snapshots older than that amount of days will be deleted") @Valid @Min(value=0L) int olderThanDays, @RequestParam(defaultValue="1000") @Valid @Min(value=1L) @Parameter(description="How much entries will be deleted at the same time") @Valid @Min(value=1L) int chunk) {
        log.info("Request to clear snapshots older than {} day(s) by {} snapshots", (Object)olderThanDays, (Object)chunk);
        this.snapshotService.pruneSnapshotsAsync(olderThanDays, chunk);
        return ResponseEntity.accepted().build();
    }
}

