/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.service.exportimport.SpecificationImportService;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.ImportSpecificationDTO;
import org.qubership.integration.platform.runtime.catalog.service.SpecificationGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/specificationGroups/import"})
@Tag(name="specification-group-import-controller", description="Specification Group Import Controller")
public class SpecificationGroupImportController {
    private static final Logger log = LoggerFactory.getLogger(SpecificationGroupImportController.class);
    private final SpecificationGroupService specificationGroupService;
    private final SpecificationImportService specificationImportService;

    @Autowired
    public SpecificationGroupImportController(SpecificationGroupService specificationGroupService, SpecificationImportService specificationImportService) {
        this.specificationGroupService = specificationGroupService;
        this.specificationImportService = specificationImportService;
    }

    @PostMapping
    @Operation(description="Create specification group from a file")
    public ResponseEntity<ImportSpecificationDTO> importSpecificationGroup(@RequestParam @Parameter(description="Service id") String systemId, @RequestParam(value="name") @Parameter(description="Specification group name") String specificationName, @RequestParam(required=false) @Parameter(description="Specification protocol") String protocol, @RequestParam @Parameter(description="Array of specification files") MultipartFile[] files) {
        SpecificationGroup specificationGroup = this.specificationGroupService.createAndSaveSpecificationGroup(systemId, specificationName, protocol, files);
        String importId = this.specificationImportService.importSpecification(specificationGroup.getId(), files);
        ImportSpecificationDTO responseDTO = new ImportSpecificationDTO(importId, false);
        responseDTO.setSpecificationGroupId(specificationGroup.getId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(ServletUriComponentsBuilder.fromCurrentRequest().path("/{importId}").buildAndExpand(new Object[]{responseDTO.getId()}).toUri())).body((Object)responseDTO);
    }
}

