/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.HashMap;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdempotencyPropertiesBuilder
implements ElementPropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(IdempotencyPropertiesBuilder.class);

    @Override
    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "http-trigger".equals(type) || "rabbitmq-trigger-2".equals(type) || "kafka-trigger-2".equals(type) || "async-api-trigger".equals(type);
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Boolean enableIdempotency = Boolean.valueOf(element.getPropertyAsString("enableIdempotency"));
        properties.put("idempotencyEnabled", enableIdempotency.toString());
        if (enableIdempotency.booleanValue()) {
            properties.put("expiry", element.getPropertyAsString("idempotencyKeyExpiry"));
        }
        return properties;
    }
}

