/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.AdditionalPropertiesBuilder;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.AdditionalPropertiesBuilderProvider;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KafkaElementPropertiesBuilder
implements ElementPropertiesBuilder {
    private final Collection<AdditionalPropertiesBuilder> additionalPropertiesBuilders;

    @Autowired
    public KafkaElementPropertiesBuilder(AdditionalPropertiesBuilderProvider additionalPropertiesBuilderProvider) {
        this.additionalPropertiesBuilders = additionalPropertiesBuilderProvider.getBuilders(KafkaElementPropertiesBuilder.class);
    }

    @Override
    public boolean applicableTo(ChainElement element) {
        return Set.of("kafka", "kafka-sender", "kafka-trigger-2", "kafka-sender-2").contains(element.getType());
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        Map<String, String> elementProperties = this.buildKafkaConnectionProperties(element.getPropertyAsString("topics"), element.getPropertyAsString("brokers"), element.getPropertyAsString("securityProtocol"), element.getPropertyAsString("saslMechanism"), element.getPropertyAsString("saslJaasConfig"), element.getPropertyAsString("connectionSourceType"));
        if ("kafka-trigger-2".equals(element.getType())) {
            elementProperties.put("groupId", element.getPropertyAsString("groupId"));
        }
        this.enrichWithAdditionalProperties(element, elementProperties);
        return elementProperties;
    }

    public Map<String, String> buildKafkaConnectionProperties(String topics, String brokers, String securityProtocol, String saslMechanism, String saslJaasConfig, String sourceType) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("topics", topics);
        properties.put("brokers", brokers);
        properties.put("securityProtocol", securityProtocol);
        properties.put("saslMechanism", saslMechanism);
        properties.put("saslJaasConfig", saslJaasConfig);
        properties.put("connectionSourceType", sourceType);
        properties.put("integrationOperationProtocolType", "kafka");
        return properties;
    }

    public void enrichWithAdditionalProperties(ChainElement element, Map<String, String> elementProperties) {
        this.additionalPropertiesBuilders.forEach(builder -> elementProperties.putAll(builder.build(element)));
    }
}

