/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.TransactionHandler;
import org.qubership.integration.platform.catalog.persistence.configs.entity.ConfigParameter;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationState;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationStatus;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ValidationChainAlertRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ValidationStatusRepository;
import org.qubership.integration.platform.catalog.service.ConfigParameterService;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationAlertsSet;
import org.qubership.integration.platform.runtime.catalog.model.filter.FilterFeature;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationFilterDTO;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.AbstractValidation;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.ValidationAlreadyInProgressUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.external.ExternalValidation;
import org.qubership.integration.platform.runtime.catalog.service.filter.ChainAlertFilterSpecificationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DiagnosticService {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticService.class);
    private static final String DIAGNOSTIC_NAMESPACE = "diagnostic";
    private static final String DIAGNOSTIC_VALIDATION_STATE_UPDATE_LOCK_NAME = "diagnosticValidationUpdateLock";
    private static final int VALIDATION_DB_LOCK_TIMEOUT_MINUTES = 15;
    private final Map<String, AbstractValidation> validations = new HashMap<String, AbstractValidation>();
    private final ValidationChainAlertRepository chainAlertRepository;
    private final ValidationStatusRepository validationStatusRepository;
    private final ConfigParameterService configParameterService;
    private final TransactionHandler transactionHandler;
    private final ChainAlertFilterSpecificationBuilder chainAlertSpecBuilder;
    private final EntityManager entityManager;

    @Autowired
    public DiagnosticService(ValidationChainAlertRepository chainAlertRepository, List<BuiltinValidation> builtinValidations, ValidationStatusRepository validationStatusRepository, ConfigParameterService configParameterService, TransactionHandler transactionHandler, ChainAlertFilterSpecificationBuilder chainAlertSpecBuilder, EntityManager entityManager) {
        this.validationStatusRepository = validationStatusRepository;
        this.configParameterService = configParameterService;
        this.transactionHandler = transactionHandler;
        this.chainAlertSpecBuilder = chainAlertSpecBuilder;
        this.validations.putAll(builtinValidations.stream().collect(Collectors.toMap(AbstractValidation::getId, Function.identity())));
        this.chainAlertRepository = chainAlertRepository;
        this.entityManager = entityManager;
    }

    @Transactional
    public List<Pair<AbstractValidation, ValidationAlertsSet>> getFilteredValidations(DiagnosticValidationFilterDTO filterRequest) {
        Map<String, Pair<AbstractValidation, ValidationAlertsSet>> result;
        if (filterRequest == null || StringUtils.isEmpty((CharSequence)filterRequest.getSearchString()) && CollectionUtils.isEmpty(filterRequest.getFilters())) {
            result = this.validations.values().stream().collect(Collectors.toMap(AbstractValidation::getId, validation -> Pair.of((Object)validation, (Object)ValidationAlertsSet.builder().alertsCount(this.getAlertsCount(validation.getId())).build())));
        } else {
            boolean searchMode = StringUtils.isNotEmpty((CharSequence)filterRequest.getSearchString());
            List<FilterRequestDTO> filters = searchMode ? Stream.of(FilterFeature.CHAIN_NAME, FilterFeature.ELEMENT_NAME, FilterFeature.ELEMENT_TYPE).map(feature -> FilterRequestDTO.builder().feature((FilterFeature)((Object)feature)).value(filterRequest.getSearchString()).condition(FilterCondition.CONTAINS).build()).toList() : filterRequest.getFilters();
            result = this.executeChainAlertFilterQuery(filters.stream().filter(filter -> filter.getFeature() != FilterFeature.VALIDATION_SEVERITY).toList(), searchMode);
            result = this.applyExtraFilters(result, filters, filterRequest.getSearchString(), searchMode);
        }
        return result.values().stream().toList();
    }

    private Map<String, Pair<AbstractValidation, ValidationAlertsSet>> executeChainAlertFilterQuery(List<FilterRequestDTO> filters, boolean searchMode) {
        HashMap<String, Pair<AbstractValidation, ValidationAlertsSet>> result = new HashMap<String, Pair<AbstractValidation, ValidationAlertsSet>>();
        Specification<ValidationChainAlert> specification = searchMode ? this.chainAlertSpecBuilder.buildSearch(filters) : this.chainAlertSpecBuilder.buildFilter(filters);
        List chainAlerts = this.chainAlertRepository.findAll(specification);
        for (ValidationChainAlert chainAlert : chainAlerts) {
            if (!this.validations.containsKey(chainAlert.getValidationId())) continue;
            Pair resultPair = result.computeIfAbsent(chainAlert.getValidationId(), validationId -> Pair.of((Object)this.validations.get(validationId), (Object)new ValidationAlertsSet()));
            ((ValidationAlertsSet)resultPair.getRight()).getChainAlerts().add(chainAlert);
        }
        for (Pair pair : result.values()) {
            ValidationAlertsSet alertsSet = (ValidationAlertsSet)pair.getRight();
            long alertsCount = this.getAlertsCount(alertsSet.getChainAlerts());
            alertsSet.setAlertsCount(alertsCount);
        }
        return result;
    }

    private Map<String, Pair<AbstractValidation, ValidationAlertsSet>> applyExtraFilters(Map<String, Pair<AbstractValidation, ValidationAlertsSet>> result, List<FilterRequestDTO> filters, String searchString, boolean searchMode) {
        if (filters == null || filters.isEmpty()) {
            return result;
        }
        if (searchMode) {
            List<AbstractValidation> filteredValidations = this.validations.values().stream().filter(validation -> validation.getTitle().toLowerCase().contains(searchString.toLowerCase())).toList();
            for (AbstractValidation filteredValidation : filteredValidations) {
                if (result.containsKey(filteredValidation.getId())) continue;
                List<ValidationChainAlert> alerts = this.getAllChainAlertsByValidationId(filteredValidation.getId());
                long count = this.getAlertsCount(alerts);
                ValidationAlertsSet alertsSet = ValidationAlertsSet.builder().alertsCount(count).chainAlerts(alerts).build();
                result.put(filteredValidation.getId(), (Pair<AbstractValidation, ValidationAlertsSet>)Pair.of((Object)filteredValidation, (Object)alertsSet));
            }
        } else {
            boolean filterApplied = false;
            HashSet<String> filteredValidations = new HashSet<String>();
            for (FilterRequestDTO filter : filters) {
                switch (filter.getFeature()) {
                    case VALIDATION_SEVERITY: {
                        filterApplied = true;
                        for (Map.Entry<String, Pair<AbstractValidation, ValidationAlertsSet>> entry : result.entrySet()) {
                            String k = entry.getKey();
                            Pair<AbstractValidation, ValidationAlertsSet> pair = entry.getValue();
                            String value = filter.getValue();
                            Set values = Arrays.stream(value.split(",")).map(ValidationSeverity::valueOf).collect(Collectors.toSet());
                            if ((filter.getCondition() != FilterCondition.IN || !values.contains((Object)((AbstractValidation)pair.getLeft()).getSeverity())) && (filter.getCondition() != FilterCondition.NOT_IN || values.contains((Object)((AbstractValidation)pair.getLeft()).getSeverity()))) continue;
                            filteredValidations.add(k);
                        }
                        break;
                    }
                }
            }
            if (filterApplied) {
                result.keySet().retainAll(filteredValidations);
            }
        }
        return result;
    }

    @Transactional
    public Pair<AbstractValidation, ValidationAlertsSet> getValidationById(String validationId) {
        AbstractValidation validation = this.validations.get(validationId);
        if (validation == null) {
            throw new EntityNotFoundException("Can't find validation with id: " + validationId);
        }
        List<ValidationChainAlert> alerts = this.getAllChainAlertsByValidationId(validationId);
        long count = this.getAlertsCount(validationId);
        return Pair.of((Object)validation, (Object)ValidationAlertsSet.builder().alertsCount(count).chainAlerts(alerts).build());
    }

    @Transactional
    public List<ValidationChainAlert> getAllChainAlertsByValidationId(String validationId) {
        return this.chainAlertRepository.findAllByValidationId(validationId);
    }

    @Transactional
    public long getAlertsCount(String validationId) {
        return this.chainAlertRepository.countAllByValidationId(validationId);
    }

    public long getAlertsCount(List<ValidationChainAlert> chainAlerts) {
        return chainAlerts == null ? 0L : (long)chainAlerts.size();
    }

    public CompletableFuture<Void> runValidationsAsync(@Nullable Set<String> validationIds) throws DiagnosticValidationUnexpectedException {
        if (this.validationUpdateTryLock()) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Set<String> filteredIds = validationIds == null || validationIds.isEmpty() ? this.validations.keySet() : this.validations.keySet().stream().filter(validationIds::contains).collect(Collectors.toSet());
                    HashMap filteredValidations = new HashMap(filteredIds.size());
                    this.transactionHandler.runInNewTransaction(() -> {
                        for (String filteredId : filteredIds) {
                            ValidationStatus savedStatus = (ValidationStatus)this.validationStatusRepository.save((Object)ValidationStatus.builder().validationId(filteredId).startedWhen(Timestamp.valueOf(LocalDateTime.now())).state(ValidationState.IN_PROGRESS).build());
                            filteredValidations.put(filteredId, savedStatus);
                        }
                    });
                    for (Map.Entry entry : filteredValidations.entrySet()) {
                        AbstractValidation validation = this.validations.get(entry.getKey());
                        ValidationStatus state = (ValidationStatus)entry.getValue();
                        try {
                            log.info("Diagnostic validation '{}' has started", (Object)validation.getTitle());
                            this.transactionHandler.runInNewTransaction(() -> {
                                switch (validation.getEntityType()) {
                                    case CHAIN: 
                                    case CHAIN_ELEMENT: {
                                        this.chainAlertRepository.deleteAllByValidationId(validation.getId());
                                        this.chainAlertRepository.saveAll(validation.validate());
                                    }
                                }
                            });
                            state.setState(ValidationState.OK);
                            log.info("Diagnostic validation '{}' completed", (Object)validation.getTitle());
                        }
                        catch (Exception e) {
                            log.error("Validation '{}' failed with an unexpected error", (Object)validation.getTitle(), (Object)e);
                            state.setState(ValidationState.FAILED, e.getMessage());
                        }
                        this.validationStatusRepository.save((Object)state);
                    }
                    log.info("Diagnostic validations task completed");
                }
                catch (Exception e) {
                    log.error("Diagnostic validations task failed", (Throwable)e);
                }
                finally {
                    this.validationUpdateUnlock();
                }
            });
        }
        throw new ValidationAlreadyInProgressUnexpectedException("Validation(s) already in progress");
    }

    public Map<String, ValidationStatus> getCurrentStatuses() {
        List savedStates = this.validationStatusRepository.findAll();
        Map<String, ValidationStatus> result = savedStates.stream().collect(Collectors.toMap(ValidationStatus::getValidationId, Function.identity()));
        for (Map.Entry<String, AbstractValidation> entry : this.validations.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), ValidationStatus.builder().validationId(entry.getKey()).state(ValidationState.NOT_STARTED).build());
        }
        return result;
    }

    public ValidationStatus getCurrentStatus(String validationId) {
        return this.validationStatusRepository.findById((Object)validationId).orElseGet(() -> ValidationStatus.builder().validationId(validationId).state(ValidationState.NOT_STARTED).build());
    }

    public void initExternalValidations(Supplier<Collection<ExternalValidation>> externalValidationsSupplier) {
        if (this.validationUpdateTryLock()) {
            try {
                externalValidationsSupplier.get().forEach(externalValidation -> {
                    externalValidation.setEntityManager(this.entityManager);
                    this.validations.put(externalValidation.getId(), (AbstractValidation)externalValidation);
                });
            }
            finally {
                this.validationUpdateUnlock();
            }
        }
    }

    private boolean validationUpdateTryLock() {
        ConfigParameter lock = this.configParameterService.findByName(DIAGNOSTIC_NAMESPACE, DIAGNOSTIC_VALIDATION_STATE_UPDATE_LOCK_NAME);
        if (lock == null) {
            lock = new ConfigParameter(DIAGNOSTIC_NAMESPACE, DIAGNOSTIC_VALIDATION_STATE_UPDATE_LOCK_NAME);
            lock.setBoolean(true);
            this.configParameterService.update(lock);
            this.configParameterService.flush();
            return true;
        }
        if (!lock.getBoolean() || lock.getModifiedWhen().before(Timestamp.valueOf(LocalDateTime.now().minusMinutes(15L)))) {
            lock.setBoolean(true);
            this.configParameterService.update(lock);
            this.configParameterService.flush();
            return true;
        }
        return false;
    }

    private void validationUpdateUnlock() {
        ConfigParameter lock = this.configParameterService.findByName(DIAGNOSTIC_NAMESPACE, DIAGNOSTIC_VALIDATION_STATE_UPDATE_LOCK_NAME);
        lock.setBoolean(false);
        this.configParameterService.update(lock);
        this.configParameterService.flush();
    }
}

