/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.configuration.datasource;

import com.zaxxer.hikari.HikariDataSource;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.qubership.integration.platform.runtime.catalog.configuration.datasource.properties.HikariConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration
@EnableConfigurationProperties(value={HikariConfigProperties.class})
@EnableJpaRepositories(basePackages={"org.qubership.integration.platform.catalog.persistence.configs.repository", "org.qubership.integration.platform.runtime.catalog.persistence.configs.repository"}, transactionManagerRef="configsTransactionManager")
public class PersistenceAutoConfiguration {
    private static final String[] JPA_ENTITIES_PACKAGES_SCAN = new String[]{"org.qubership.integration.platform.catalog.persistence.configs.entity", "org.qubership.integration.platform.runtime.catalog.persistence.configs.entity"};
    private final JpaProperties jpaProperties;
    private final HikariConfigProperties properties;

    @Autowired
    public PersistenceAutoConfiguration(JpaProperties jpaProperties, HikariConfigProperties properties) {
        this.jpaProperties = jpaProperties;
        this.properties = properties;
    }

    @Primary
    @Bean(value={"configsDataSource"})
    @ConditionalOnMissingBean(value={DataSource.class}, name={"configsDataSource"})
    public DataSource configsDataSource() {
        return new HikariDataSource(this.properties.getDatasource("configs-datasource"));
    }

    @Bean
    JdbcTemplate configsJdbcTemplate(@Qualifier(value="configsDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    NamedParameterJdbcTemplate configsNamedParameterJdbcTemplate(@Qualifier(value="configsDataSource") DataSource dataSource) {
        return new NamedParameterJdbcTemplate(dataSource);
    }

    @Primary
    @Bean(value={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean configsEntityManagerFactory(@Qualifier(value="configsDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
        jpaVendorAdapter.setDatabase(this.jpaProperties.getDatabase());
        jpaVendorAdapter.setGenerateDdl(this.jpaProperties.isGenerateDdl());
        jpaVendorAdapter.setShowSql(this.jpaProperties.isShowSql());
        em.setDataSource(dataSource);
        em.setJpaVendorAdapter((JpaVendorAdapter)jpaVendorAdapter);
        em.setPackagesToScan(JPA_ENTITIES_PACKAGES_SCAN);
        em.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
        em.setJpaProperties(this.additionalProperties());
        em.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        return em;
    }

    @Primary
    @Bean(value={"configsTransactionManager"})
    public PlatformTransactionManager configsTransactionManager(@Qualifier(value="entityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory.getObject());
        return transactionManager;
    }

    private Properties additionalProperties() {
        Properties properties = new Properties();
        if (this.jpaProperties != null) {
            properties.putAll((Map<?, ?>)this.jpaProperties.getProperties());
        }
        return properties;
    }
}

