/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.qubership.integration.platform.runtime.catalog.rest.handler.exception.MicroserviceErrorResponseException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.ExceptionDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResponseErrorHandler;

@Component
public class RestTemplateMsResponseErrorHandler
implements ResponseErrorHandler {
    private final ObjectMapper objectMapper;

    @Autowired
    public RestTemplateMsResponseErrorHandler(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return response.getStatusCode().isError();
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        String errorMessage = IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
        try {
            ExceptionDTO exceptionDTO = (ExceptionDTO)this.objectMapper.readValue(errorMessage, ExceptionDTO.class);
            errorMessage = exceptionDTO.getErrorMessage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MicroserviceErrorResponseException(errorMessage, (HttpStatus)response.getStatusCode(), response.getHeaders());
    }
}

