/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeploymentsDTO;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentsUpdate;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.EngineDeploymentResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.DomainResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.EngineResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentMapper;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.EngineMapper;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.EngineService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/domains"})
@CrossOrigin(origins={"*"})
@Tag(name="engine-controller", description="Engine Controller")
public class EngineController {
    private static final Logger log = LoggerFactory.getLogger(EngineController.class);
    private final EngineMapper engineMapper;
    private final EngineService engineService;
    private final DeploymentMapper deploymentMapper;
    private final DeploymentService deploymentService;
    private final RuntimeDeploymentService runtimeDeploymentService;

    @Autowired
    EngineController(EngineService engineService, EngineMapper engineMapper, DeploymentMapper deploymentMapper, DeploymentService deploymentService, RuntimeDeploymentService runtimeDeploymentService) {
        this.engineService = engineService;
        this.engineMapper = engineMapper;
        this.deploymentMapper = deploymentMapper;
        this.deploymentService = deploymentService;
        this.runtimeDeploymentService = runtimeDeploymentService;
    }

    @GetMapping
    @Operation(description="Get all available engine domains")
    ResponseEntity<List<DomainResponse>> getDomains() {
        List domains = this.engineService.getDomains();
        return ResponseEntity.ok((Object)this.engineMapper.asDomainResponses(domains));
    }

    @GetMapping(value={"/{domainName}/engines"})
    @Operation(description="Get available engines for the domain")
    ResponseEntity<List<EngineResponse>> getEngines(@PathVariable @Parameter(description="Engine domain name") String domainName) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get engines by domain {}", (Object)domainName);
        }
        return ResponseEntity.ok((Object)this.engineMapper.asEngineResponses(this.engineService.getEnginesPods(domainName)));
    }

    @GetMapping(value={"/hosts"})
    @Operation(description="Get all engine hosts in format <domain, list of ip>")
    public ResponseEntity<Map<String, List<String>>> getAllEngineHosts() {
        if (log.isDebugEnabled()) {
            log.debug("Request to get hosts with domain");
        }
        return ResponseEntity.ok((Object)this.runtimeDeploymentService.getEngineHosts());
    }

    @GetMapping(value={"/{domainName}/engines/{engineHost}/deployments"})
    @Operation(description="Get deployments from specified engine pod")
    ResponseEntity<List<EngineDeploymentResponse>> getEngineDeployments(@PathVariable @Parameter(description="Engine domain name") String domainName, @PathVariable @Parameter(description="Engine pod's ip address") String engineHost) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get engine deployments by domain {} and engine host {}", (Object)domainName, (Object)engineHost);
        }
        return ResponseEntity.ok((Object)this.deploymentMapper.asEngineDeployments(this.runtimeDeploymentService.findRuntimeDeployments(engineHost)));
    }

    @GetMapping(value={"/{domainName}/deployments/count"})
    @Operation(description="Get amount of deployments on specified domain")
    ResponseEntity<Long> getDeploymentsCountByDomain(@PathVariable @Parameter(description="Engine domain name") String domainName) {
        return ResponseEntity.ok((Object)this.engineService.deploymentsCountByDomain(domainName));
    }

    @PostMapping(path={"/{domainName}/deployments/update"}, produces={"application/json"})
    @Operation(description="Get deployments update for particular engine, for internal use")
    ResponseEntity<DeploymentsUpdate> getDeploymentsUpdate(@PathVariable @Parameter(description="Engine domain name") String domainName, @RequestBody @Parameter(description="Engine deployments update request object") EngineDeploymentsDTO engineDeployments) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get deployments for engine with domain {}", (Object)domainName);
        }
        try {
            DeploymentsUpdate deploymentsUpdate = this.deploymentService.getDeploymentsForDomain(domainName, engineDeployments);
            return ResponseEntity.ok((Object)deploymentsUpdate);
        }
        catch (Exception e) {
            log.error("Failed to get deployments for engine update", (Throwable)e);
            throw e;
        }
    }
}

