/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.List;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.system.ImportSystemResult;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.ImportSystemStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v3.controller.ImportControllerV3;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.SystemExportImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1"})
@Tag(name="system-export-import-controller", description="System Export Import Controller")
public class SystemExportImportController {
    private static final Logger log = LoggerFactory.getLogger(SystemExportImportController.class);
    private final SystemExportImportService systemExportImportService;

    @Autowired
    public SystemExportImportController(SystemExportImportService systemExportImportService) {
        this.systemExportImportService = systemExportImportService;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/export/system"}, produces={"application/octet-stream"})
    @Operation(description="Export services as an archive")
    public ResponseEntity<Object> exportSystems(@RequestParam(required=false) @Parameter(description="List of service ids, separated by comma") List<String> systemIds, @RequestParam(required=false) @Parameter(description="If specified, only these specifications will be exported") List<String> usedSystemModelIds) {
        byte[] zip = this.systemExportImportService.exportSystemsRequest(systemIds, usedSystemModelIds);
        if (zip == null) {
            return ResponseEntity.noContent().build();
        }
        return ExportImportUtils.convertFileToResponse((byte[])zip, (String)ExportImportUtils.generateArchiveExportName());
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Import service from a file")
    @PostMapping(value={"/import/system"})
    public ResponseEntity<List<ImportSystemResult>> importSystems(@RequestParam(value="file") @Parameter(description="File") MultipartFile file, @RequestParam(required=false) @Parameter(description="List of service ids, separated by comma") List<String> systemIds, @RequestParam(required=false) @Parameter(description="If specified, all environments with specified label will be set as active") String deployLabel, @RequestHeader(required=false, value="X-SR-Package-Name") @Parameter(description="Package name samples repository header") String packageName, @RequestHeader(required=false, value="X-SR-Package-Version") @Parameter(description="Package version samples repository header") String packageVersion, @RequestHeader(required=false, value="X-SR-Part-Of") @Parameter(description="Package part of samples repository header") String packagePartOf) {
        List technicalLabels = ImportControllerV3.addSamplesRepoTechnicalLabels(null, (String[])new String[]{packagePartOf, packageName, packageVersion});
        List result = this.systemExportImportService.importSystemRequest(file, systemIds, deployLabel, new HashSet(technicalLabels));
        if (result.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        HttpStatus responseCode = result.stream().anyMatch(dto -> dto.getStatus().equals((Object)ImportSystemStatus.ERROR)) ? HttpStatus.MULTI_STATUS : HttpStatus.OK;
        return ResponseEntity.status((HttpStatusCode)responseCode).body((Object)result);
    }

    @PostMapping(value={"/import/systemPreview"})
    @Operation(description="Get preview on what will be imported from file")
    public ResponseEntity<List<ImportSystemResult>> getSystemsImportPreview(@RequestParam(value="file") @Parameter(description="File") MultipartFile file) {
        List result = this.systemExportImportService.getSystemsImportPreviewRequest(file);
        return result.isEmpty() ? ResponseEntity.noContent().build() : ResponseEntity.ok().body((Object)result);
    }
}

