/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.ChainBaseService;
import org.qubership.integration.platform.catalog.service.ElementBaseService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ChainService
extends ChainBaseService {
    private static final Logger log = LoggerFactory.getLogger(ChainService.class);
    private static final String CHAIN_WITH_ID_NOT_FOUND_MESSAGE = "Can't find chain with id: ";
    private final ChainRepository chainRepository;
    private final DeploymentService deploymentService;
    private final ActionsLogService actionLogger;

    @Autowired
    public ChainService(ChainRepository chainRepository, ElementService elementService, @Lazy DeploymentService deploymentService, ActionsLogService actionLogger) {
        super(chainRepository, (ElementBaseService)elementService);
        this.chainRepository = chainRepository;
        this.deploymentService = deploymentService;
        this.actionLogger = actionLogger;
    }

    public Boolean exists(String chainId) {
        return this.chainRepository.existsById((Object)chainId);
    }

    public List<Chain> findAll() {
        return this.chainRepository.findAll();
    }

    public List<Chain> findAllById(List<String> chainIds) {
        return this.chainRepository.findAllById(chainIds);
    }

    public Chain findById(String chainId) {
        return (Chain)this.chainRepository.findById((Object)chainId).orElseThrow(() -> new EntityNotFoundException(CHAIN_WITH_ID_NOT_FOUND_MESSAGE + chainId));
    }

    public List<String> getSubChainsIds(List<String> chainsIds, List<String> resultChainsIds) {
        resultChainsIds.addAll(chainsIds);
        List subChainsIds = this.chainRepository.findSubChains(chainsIds);
        subChainsIds.removeAll(resultChainsIds);
        if (!subChainsIds.isEmpty()) {
            this.getSubChainsIds(subChainsIds, resultChainsIds);
        }
        return resultChainsIds;
    }

    public Optional<Chain> tryFindById(String chainId) {
        return this.chainRepository.findById((Object)chainId);
    }

    public boolean setOverriddenById(String chainId, String overriddenById) {
        Optional optionalChain = this.tryFindById(chainId);
        if (optionalChain.isPresent()) {
            Chain chain = (Chain)optionalChain.get();
            chain.setOverriddenByChainId(overriddenById);
            if (chain.getLabels().stream().noneMatch(label -> "Overridden".equals(label.getName()))) {
                chain.addLabel(((ChainLabel.ChainLabelBuilder)((ChainLabel.ChainLabelBuilder)ChainLabel.builder().name("Overridden")).technical(true)).chain(chain).build());
            }
            this.chainRepository.save((Object)chain);
            return true;
        }
        return false;
    }

    public boolean setOverridesChainId(String chainId, String overriddenById) {
        Optional optionalChain = this.tryFindById(overriddenById);
        if (optionalChain.isPresent()) {
            Chain chain = (Chain)optionalChain.get();
            chain.setOverridesChainId(chainId);
            if (chain.getLabels().stream().noneMatch(label -> "Overrides".equals(label.getName()))) {
                chain.addLabel(((ChainLabel.ChainLabelBuilder)((ChainLabel.ChainLabelBuilder)ChainLabel.builder().name("Overrides")).technical(true)).chain(chain).build());
            }
            this.chainRepository.save((Object)chain);
            return true;
        }
        return false;
    }

    public void clearCurrentSnapshot(String chainId) {
        this.chainRepository.updateCurrentSnapshot(chainId, null);
        this.chainRepository.updateUnsavedChanges(chainId, true);
    }

    public void setCurrentSnapshot(String chainId, Snapshot snapshot) {
        this.chainRepository.updateCurrentSnapshot(chainId, snapshot);
        this.chainRepository.updateUnsavedChanges(chainId, false);
    }

    public void overrideModificationTimestamp(Chain chain, Timestamp timestamp) {
        this.chainRepository.updateModificationTimestamp(chain.getId(), timestamp);
    }

    public void setActualizedChainState(Chain currentChainState, Chain newChainState) {
        this.chainRepository.actualizeObjectState((Object)currentChainState, (Object)newChainState);
    }

    public void update(Chain chain) {
        this.chainRepository.save((Object)chain);
        this.logChainAction(chain, LogOperation.UPDATE);
    }

    public String getChainHash(String chainId) {
        return this.chainRepository.getChainLastImportHash(chainId);
    }

    public void clearContext() {
        this.chainRepository.clearContext();
    }

    public Optional<Chain> deleteByIdIfExists(String chainId) {
        this.deploymentService.deleteAllByChainId(chainId);
        Optional optionalChain = this.tryFindById(chainId);
        if (optionalChain.isPresent()) {
            Chain chain = (Chain)optionalChain.get();
            this.chainRepository.deleteById((Object)chainId);
            this.logChainAction(chain, LogOperation.DELETE);
        }
        return optionalChain;
    }

    private void logChainAction(Chain chain, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(chain.getId()).entityName(chain.getName()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).operation(operation).build());
    }
}

