/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.CompiledLibrary;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemModelLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemModelRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.SystemModelBaseService;
import org.qubership.integration.platform.catalog.service.codegen.SystemModelCodeGenerator;
import org.qubership.integration.platform.catalog.service.compiler.CompilerService;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemModelService
extends SystemModelBaseService {
    private static final Logger log = LoggerFactory.getLogger(SystemModelService.class);
    private final ChainService chainService;

    @Autowired
    public SystemModelService(SystemModelRepository systemModelRepository, List<SystemModelCodeGenerator> codeGenerators, CompilerService compilerService, SystemModelLabelsRepository systemModelLabelsRepository, ChainService chainService, ActionsLogService actionLogger) {
        super(systemModelRepository, codeGenerators, compilerService, systemModelLabelsRepository, actionLogger);
        this.chainService = chainService;
    }

    public SystemModel getSystemModelOrElseNull(String modelId) {
        return this.systemModelRepository.findById((Object)modelId).orElse(null);
    }

    @Transactional
    public Pair<byte[], String> getCompiledLibrary(String modelId) {
        SystemModel model = this.getSystemModel(modelId);
        CompiledLibrary compiledLibrary = model.getCompiledLibrary();
        if (Objects.isNull(compiledLibrary)) {
            return null;
        }
        String name = compiledLibrary.getName();
        byte[] data = compiledLibrary.getData();
        return Objects.isNull(data) ? null : Pair.of((Object)data, (Object)name);
    }

    public Optional<SystemModel> deleteSystemModelByIdIfExists(String modelId) {
        Optional specificationOptional = this.systemModelRepository.findById((Object)modelId);
        if (specificationOptional.isPresent()) {
            if (this.chainService.isSystemModelUsedByChain(modelId)) {
                throw new IllegalArgumentException("Specification used by one or more chains");
            }
            SystemModel specification = (SystemModel)specificationOptional.get();
            this.systemModelRepository.delete((Object)specification);
            this.logModelAction(specification, specification.getSpecificationGroup(), LogOperation.DELETE);
        }
        return specificationOptional;
    }
}

