/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.qubership.integration.platform.catalog.context.RequestIdContext;
import org.qubership.integration.platform.catalog.mapping.exportimport.instructions.GeneralInstructionsMapper;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.GeneralImportInstructionsConfig;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceRequest;
import org.qubership.integration.platform.catalog.service.difference.EntityDifferenceResult;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportChainsAndInstructionsResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportSystemsAndInstructionsResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.variable.ImportVariablesResult;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.ImportSession;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportPreviewResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportRequest;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ChainImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.CommonVariablesImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.SystemExportImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.instructions.ImportInstructionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GeneralImportService {
    private static final Logger log = LoggerFactory.getLogger(GeneralImportService.class);
    private final CommonVariablesImportService commonVariablesImportService;
    private final SystemExportImportService systemExportImportService;
    private final ChainImportService chainImportService;
    private final ImportSessionService importSessionService;
    private final ActionsLogService actionsLogService;
    private final ImportInstructionsService importInstructionsService;
    private final GeneralInstructionsMapper generalInstructionsMapper;

    @Autowired
    public GeneralImportService(CommonVariablesImportService commonVariablesImportService, SystemExportImportService systemExportImportService, ChainImportService chainImportService, ImportSessionService importSessionService, ActionsLogService actionsLogService, ImportInstructionsService importInstructionsService, GeneralInstructionsMapper generalInstructionsMapper) {
        this.commonVariablesImportService = commonVariablesImportService;
        this.systemExportImportService = systemExportImportService;
        this.chainImportService = chainImportService;
        this.importSessionService = importSessionService;
        this.actionsLogService = actionsLogService;
        this.importInstructionsService = importInstructionsService;
        this.generalInstructionsMapper = generalInstructionsMapper;
    }

    @Nullable
    public ImportSession getImportSession(String importId) {
        return this.importSessionService.getImportSession(importId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportPreviewResponse getImportPreview(MultipartFile file) {
        File unpackedDirectory = null;
        try {
            unpackedDirectory = this.unpackDirectory(file);
            File importInstructionsConfigFile = new File(unpackedDirectory, this.importInstructionsService.getInstructionsFileName());
            List importInstructions = importInstructionsConfigFile.exists() ? this.importInstructionsService.getImportInstructionsForPreview(importInstructionsConfigFile) : this.importInstructionsService.getAllImportInstructions();
            GeneralImportInstructionsConfig instructionsConfig = this.generalInstructionsMapper.asConfig(importInstructions);
            ImportPreviewResponse importPreviewResponse = ImportPreviewResponse.builder().variables(this.commonVariablesImportService.getCommonVariablesImportPreview(unpackedDirectory)).chains(this.chainImportService.getChainsImportPreview(unpackedDirectory, instructionsConfig.getChains())).systems(this.systemExportImportService.getSystemsImportPreview(unpackedDirectory, instructionsConfig.getServices())).instructions(this.generalInstructionsMapper.asDTO(importInstructions)).build();
            return importPreviewResponse;
        }
        finally {
            ExportImportUtils.deleteFile((File)unpackedDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDifferenceResult compareImportEntities(MultipartFile file, ChainDifferenceRequest diffRequest) {
        File unpackedDirectory = null;
        try {
            unpackedDirectory = this.unpackDirectory(file);
            EntityDifferenceResult entityDifferenceResult = this.chainImportService.compareChains(unpackedDirectory, diffRequest);
            return entityDifferenceResult;
        }
        finally {
            ExportImportUtils.deleteFile((File)unpackedDirectory);
        }
    }

    public String importFileAsync(MultipartFile file, ImportRequest importRequest, Set<String> technicalLabels, boolean validateByHash) {
        String importId = UUID.randomUUID().toString();
        this.importSessionService.deleteObsoleteImportSessionStatuses();
        this.importSessionService.setImportProgressPercentage(importId, 0);
        File unpackedDirectory = this.unpackDirectory(file);
        this.logImportAction(file.getOriginalFilename());
        String requestId = RequestIdContext.get();
        CompletableFuture.supplyAsync(() -> {
            RequestIdContext.set((String)requestId);
            log.info("Import session {} started", (Object)importId);
            ArrayList importInstructionResults = new ArrayList();
            File importInstructionsConfigFile = new File(unpackedDirectory, this.importInstructionsService.getInstructionsFileName());
            if (importInstructionsConfigFile.exists()) {
                log.info("Start uploading import instructions");
                importInstructionResults.addAll(this.importInstructionsService.uploadImportInstructionsConfig(importInstructionsConfigFile, technicalLabels));
            }
            ImportVariablesResult variablesResult = this.commonVariablesImportService.importCommonVariables(unpackedDirectory, importRequest.getVariablesCommitRequest(), importId);
            ImportSystemsAndInstructionsResult importSystemsAndInstructionsResult = this.systemExportImportService.importSystems(unpackedDirectory, importRequest.getSystemsCommitRequest(), importId, technicalLabels);
            ImportChainsAndInstructionsResult importChainsAndInstructionsResult = this.chainImportService.importChains(unpackedDirectory, importRequest.getChainCommitRequests(), importId, technicalLabels, validateByHash);
            importInstructionResults.addAll(importChainsAndInstructionsResult.instructionResults());
            importInstructionResults.addAll(importSystemsAndInstructionsResult.instructionResults());
            importInstructionResults.addAll(variablesResult.getInstructions());
            return ImportResult.builder().chains(importChainsAndInstructionsResult.chainResults()).systems(importSystemsAndInstructionsResult.importSystemResults()).variables(variablesResult.getVariables()).instructionsResult(importInstructionResults).build();
        }).whenCompleteAsync((response, throwable) -> {
            RequestIdContext.set((String)requestId);
            this.completeAsyncImport(importId, response, unpackedDirectory, throwable);
        });
        return importId;
    }

    private void completeAsyncImport(String importId, ImportResult importResult, File unpackedDirectory, Throwable throwable) {
        ExportImportUtils.deleteFile((File)unpackedDirectory);
        ImportSession importSession = new ImportSession();
        importSession.setId(importId);
        importSession.setCompletion(100);
        if (importResult != null) {
            importSession.setResult(importResult);
        }
        if (throwable != null) {
            String string;
            if (throwable instanceof CompletionException) {
                CompletionException exception = (CompletionException)throwable;
                string = exception.getCause().getMessage();
            } else {
                string = throwable.getMessage();
            }
            String errorMessage = string;
            importSession.setError(errorMessage);
            log.error("Error async importing file", throwable);
        }
        this.importSessionService.saveImportSession(importSession);
    }

    private File unpackDirectory(MultipartFile file) {
        File unpackDirectory = null;
        try (InputStream is = file.getInputStream();){
            unpackDirectory = this.unpackZIP(is);
        }
        catch (Exception e) {
            ExportImportUtils.deleteFile(unpackDirectory);
            log.warn("Exception while extract files from zip", (Throwable)e);
            throw new RuntimeException("Exception while extract files from zip", e);
        }
        return unpackDirectory;
    }

    private File unpackZIP(InputStream is) throws IOException {
        return ExportImportUtils.extractDirectoriesFromZip((InputStream)is, (String)UUID.randomUUID().toString());
    }

    private void logImportAction(String archiveName) {
        this.actionsLogService.logAction(ActionLog.builder().entityType(EntityType.CHAINS).entityName(archiveName).operation(LogOperation.IMPORT).build());
    }
}

