/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.Collection;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;

public class CompoundPropertiesVerifier
implements ElementPropertiesVerifier {
    private final Collection<ElementPropertiesVerifier> verifiers;

    public CompoundPropertiesVerifier(Collection<ElementPropertiesVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    public boolean applicableTo(ChainElement element) {
        return this.verifiers.stream().anyMatch(verifier -> verifier.applicableTo(element));
    }

    public Collection<VerificationError> verify(ChainElement element) {
        return this.verifiers.stream().map(verifier -> verifier.verify(element)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

