/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers.MaasElementPropertiesVerifierHelper;
import org.springframework.stereotype.Component;

@Component
public class OperationElementPropertiesVerifier
implements ElementPropertiesVerifier {
    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "async-api-trigger".equals(type) || "service-call".equals(type);
    }

    public Collection<VerificationError> verify(ChainElement element) {
        return Optional.ofNullable(element.getEnvironment()).map(environment -> this.verifyProperties(element, environment)).orElse(Collections.emptyList());
    }

    private Collection<VerificationError> verifyProperties(ChainElement element, ServiceEnvironment environment) {
        Object protocolType = element.getProperty("integrationOperationProtocolType");
        if ("kafka".equals(protocolType) || "amqp".equals(protocolType)) {
            String sourceType = Optional.ofNullable(environment.getSourceType()).map(String::valueOf).orElse(null);
            String maasClassifier = (String)ElementUtils.extractOperationAsyncProperties((Map)element.getProperties()).get("maas.classifier.name");
            if (StringUtils.isEmpty((CharSequence)maasClassifier) && "amqp".equals(protocolType)) {
                maasClassifier = "public";
            }
            return MaasElementPropertiesVerifierHelper.verifyMaasProperties((String)sourceType, (String)maasClassifier);
        }
        return Collections.emptyList();
    }
}

