/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers.MaasElementPropertiesVerifierHelper;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqElementPropertiesVerifier
implements ElementPropertiesVerifier {
    public boolean applicableTo(ChainElement element) {
        return List.of("rabbitmq", "rabbitmq-sender", "rabbitmq-trigger-2", "rabbitmq-sender-2").contains(element.getType());
    }

    public Collection<VerificationError> verify(ChainElement element) {
        String sourceType = element.getPropertyAsString("connectionSourceType");
        String maasClassifier = Optional.ofNullable(element.getPropertyAsString("vhostClassifierName")).orElse("public");
        return MaasElementPropertiesVerifierHelper.verifyMaasProperties((String)sourceType, (String)maasClassifier);
    }
}

