/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.LiveExchangeExtDTO;
import org.qubership.integration.platform.runtime.catalog.service.LiveExchangesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/live-exchanges"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="live-exchanges-controller", description="Live Exchanges Controller")
public class LiveExchangesController {
    private final LiveExchangesService liveExchangesService;

    @Autowired
    public LiveExchangesController(LiveExchangesService liveExchangesService) {
        this.liveExchangesService = liveExchangesService;
    }

    @GetMapping
    @Operation(description="Get top N running sessions live exchanges ordered by execution time DESC from all running engines")
    public ResponseEntity<List<LiveExchangeExtDTO>> getLiveExchanges(@RequestParam(required=false, defaultValue="10") @Positive @Parameter(description="Amount of entries to view") Integer limit) {
        List<LiveExchangeExtDTO> result = this.liveExchangesService.getTopLongLiveExchanges(limit);
        if (CollectionUtils.isEmpty(result)) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(result);
    }

    @DeleteMapping(value={"/{podIp}/{deploymentId}/{exchangeId}"})
    @Operation(description="Try to kill specified live exchange")
    public ResponseEntity<Void> killExchange(@PathVariable @NotBlank @Parameter(description="Engine pod ip") String podIp, @PathVariable @NotBlank @Parameter(description="Deployment ID") String deploymentId, @PathVariable @NotBlank @Parameter(description="Exchange ID") String exchangeId) {
        this.liveExchangesService.sendKillExchangeRequest(podIp, deploymentId, exchangeId);
        return ResponseEntity.accepted().build();
    }
}

