/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.SpecificationExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/export"})
@Tag(name="specification-export-controller", description="Specification Export Controller")
public class SpecificationExportController {
    private static final Logger log = LoggerFactory.getLogger(SpecificationExportController.class);
    private final SpecificationExportService specificationExportService;

    @Autowired
    public SpecificationExportController(SpecificationExportService specificationExportService) {
        this.specificationExportService = specificationExportService;
    }

    @GetMapping(value={"/specifications"}, produces={"application/octet-stream"})
    @Operation(description="Export specifications as a file")
    public ResponseEntity<Object> exportSpecifications(@RequestParam(required=false) @Parameter(description="List of specification ids separated by comma") List<String> specificationIds, @RequestParam(required=false) @Parameter(description="List of specification group ids separated by comma") String specificationGroupId) {
        Pair<byte[], String> archivePair = this.specificationExportService.exportSpecifications(specificationIds, specificationGroupId);
        return archivePair == null ? ResponseEntity.noContent().build() : ExportImportUtils.convertFileToResponse((byte[])((byte[])archivePair.getFirst()), (String)((String)archivePair.getSecond()));
    }
}

