/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.LiveExchangeDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.engine.LiveExchangeExtDTO;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class LiveExchangesService {
    private static final Logger log = LoggerFactory.getLogger(LiveExchangesService.class);
    private static final String SESSION_GET_URL = "http://%s:8080/v1/engine/live-exchanges?limit=%d";
    private static final String SESSION_DELETE_URL = "http://%s:8080/v1/engine/live-exchanges/%s/%s";
    private final RuntimeDeploymentService runtimeDeploymentService;
    private final RestTemplate restTemplateMs;
    private final ActionsLogService actionLogger;
    private final DeploymentService deploymentService;
    private final ChainService chainService;

    @Autowired
    public LiveExchangesService(RuntimeDeploymentService runtimeDeploymentService, RestTemplate restTemplateMs, ActionsLogService actionLogger, DeploymentService deploymentService, ChainService chainService) {
        this.runtimeDeploymentService = runtimeDeploymentService;
        this.restTemplateMs = restTemplateMs;
        this.actionLogger = actionLogger;
        this.deploymentService = deploymentService;
        this.chainService = chainService;
    }

    public List<LiveExchangeExtDTO> getTopLongLiveExchanges(int limit) {
        List engineIps = this.runtimeDeploymentService.getEngineHosts().values().stream().flatMap(Collection::stream).toList();
        List<LiveExchangeExtDTO> result = ((Stream)engineIps.stream().parallel()).map(ip -> {
            LiveExchangeDTO[] requestResult = null;
            try {
                requestResult = (LiveExchangeDTO[])this.restTemplateMs.getForObject(String.format(SESSION_GET_URL, ip, limit), LiveExchangeDTO[].class, new Object[0]);
            }
            catch (Exception e) {
                log.warn("Unable to retrieve live sessions from engine ip {}", ip, (Object)e);
            }
            return Optional.ofNullable(requestResult).map(l -> Arrays.stream(l).map(le -> new LiveExchangeExtDTO((LiveExchangeDTO)le, (String)ip))).orElse(null);
        }).filter(Objects::nonNull).flatMap(l -> l).toList();
        this.enrichResultWithChainName(result);
        return result;
    }

    private void enrichResultWithChainName(List<LiveExchangeExtDTO> result) {
        Map<String, String> idNameChainMap = this.chainService.findAllById(result.stream().map(LiveExchangeDTO::getChainId).toList()).stream().collect(Collectors.toMap(AbstractEntity::getId, AbstractEntity::getName));
        result.forEach(r -> r.setChainName((String)idNameChainMap.get(r.getChainId())));
    }

    public void sendKillExchangeRequest(String podIp, String deploymentId, String exchangeId) {
        String domainName = null;
        try {
            domainName = this.deploymentService.findById(deploymentId).getDomain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.EXCHANGE).entityId(exchangeId).entityName("Exchange from " + podIp).parentType(EntityType.DEPLOYMENT).parentId(deploymentId).parentName(domainName).operation(LogOperation.DELETE).build());
        this.restTemplateMs.delete(String.format(SESSION_DELETE_URL, podIp, deploymentId, exchangeId), new Object[0]);
    }
}

