/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.consul.ConfigurationPropertiesConstants;
import org.qubership.integration.platform.catalog.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentUpdate;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentRouteMapper;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DeploymentBuilderService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentBuilderService.class);
    @Deprecated(since="23.4")
    private static final Pattern RANDOM_ID_PLACEHOLDER_PATTERN = Pattern.compile("%%\\{random-id-placeholder}");
    private static final Pattern DEPLOYMENT_ID_PLACEHOLDER_PATTERN = Pattern.compile("%%\\{deployment-id-placeholder}");
    private static final String DOMAIN_PLACEHOLDER = "%%{domain-placeholder}";
    private final ChainService chainService;
    private final SnapshotService snapshotService;
    private final ElementUtils elementUtils;
    private final ElementPropertiesBuilderFactory elementPropertiesBuilderFactory;
    private final LibraryElementsService libraryService;
    private final DeploymentRouteMapper deploymentRouteMapper;
    private final SystemService systemService;
    private final EnvironmentService environmentService;

    @Autowired
    public DeploymentBuilderService(@Lazy ChainService chainService, @Lazy SnapshotService snapshotService, ElementUtils elementUtils, ElementPropertiesBuilderFactory elementPropertiesBuilderFactory, LibraryElementsService libraryService, DeploymentRouteMapper deploymentRouteMapper, SystemService systemService, EnvironmentService environmentService) {
        this.chainService = chainService;
        this.snapshotService = snapshotService;
        this.elementUtils = elementUtils;
        this.elementPropertiesBuilderFactory = elementPropertiesBuilderFactory;
        this.libraryService = libraryService;
        this.deploymentRouteMapper = deploymentRouteMapper;
        this.systemService = systemService;
        this.environmentService = environmentService;
    }

    public List<DeploymentUpdate> buildDeploymentsUpdate(List<Deployment> deployments) {
        ArrayList<DeploymentUpdate> result = new ArrayList<DeploymentUpdate>();
        for (Deployment deployment : deployments) {
            Chain chain = this.chainService.findById(deployment.getChain().getId());
            Snapshot snapshot = this.snapshotService.findById(deployment.getSnapshot().getId());
            DeploymentConfiguration config = this.createUpdateDeploymentConfiguration(deployment);
            result.add(DeploymentUpdate.builder().deploymentInfo(DeploymentInfo.builder().deploymentId(deployment.getId()).chainId(chain.getId()).chainName(chain.getName()).snapshotName(snapshot.getName()).snapshotId(snapshot.getId()).createdWhen(Long.valueOf(deployment.getCreatedWhen().getTime())).containsCheckpointElements(Boolean.valueOf(this.containsCheckpointsElements(config.getProperties()))).containsSchedulerElements(Boolean.valueOf(this.containsSchedulerElements(config.getProperties()))).build()).maskedFields(chain.getMaskedFields().stream().map(AbstractEntity::getName).collect(Collectors.toSet())).configuration(config).build());
        }
        return result;
    }

    public List<DeploymentUpdate> buildDeploymentsStop(List<DeploymentInfo> deployments) {
        ArrayList<DeploymentUpdate> result = new ArrayList<DeploymentUpdate>();
        for (DeploymentInfo info : deployments) {
            result.add(DeploymentUpdate.builder().deploymentInfo(info).build());
        }
        return result;
    }

    private DeploymentConfiguration createUpdateDeploymentConfiguration(Deployment deployment) {
        Snapshot snapshot = deployment.getSnapshot();
        Set groupContainers = snapshot.getElements().stream().filter(item -> "container".equals(item.getType()) || Optional.ofNullable(this.libraryService.getElementDescriptor(item.getType())).map(descriptor -> ElementType.REUSE == descriptor.getType()).orElse(false) != false).collect(Collectors.toSet());
        List filteredElements = snapshot.getElements().stream().filter(item -> !item.getType().equals("container") && Optional.ofNullable(this.libraryService.getElementDescriptor(item.getType())).map(ElementDescriptor::getType).map(type -> ElementType.REUSE != type && ElementType.REUSE_REFERENCE != type && ElementType.SWIMLANE != type).orElse(true) != false).collect(Collectors.toList());
        filteredElements = this.elementUtils.splitCompositeTriggers(filteredElements);
        ArrayList<ElementProperties> elementProperties = new ArrayList<ElementProperties>();
        filteredElements.stream().map(element -> {
            String systemId;
            HashMap<String, String> properties = new HashMap<String, String>(this.elementPropertiesBuilderFactory.getElementPropertiesBuilder((ChainElement)element).build((ChainElement)element));
            if (element.getParent() != null) {
                if (!groupContainers.contains(element.getParent())) {
                    properties.put("parentElementId", element.getParent().getId());
                    properties.put("parentElementOriginalId", element.getParent().getOriginalId());
                    properties.put("parentElementName", element.getParent().getName());
                    if (ConfigurationPropertiesConstants.ELEMENTS_WITH_INTERMEDIATE_CHILDREN.contains(element.getParent().getType())) {
                        properties.put("hasIntermediateParents", Boolean.TRUE.toString());
                    }
                }
                if ("reuse".equals(element.getParent().getType())) {
                    properties.put("reuseOriginalId", element.getParent().getOriginalId());
                }
            }
            if ("service-call".equals(element.getType()) && IntegrationSystemType.EXTERNAL.name().equals(element.getProperty("systemType")) && StringUtils.isNotEmpty((CharSequence)(systemId = (String)element.getProperty("integrationSystemId")))) {
                IntegrationSystem system = this.systemService.findById(systemId);
                properties.put("externalServiceName", system.getName());
                String activeEnvironmentId = system.getActiveEnvironmentId();
                if (StringUtils.isNotEmpty((CharSequence)activeEnvironmentId)) {
                    Environment env = this.environmentService.getByIdForSystem(systemId, activeEnvironmentId);
                    properties.put("externalServiceEnvName", env.getName());
                }
            }
            return ElementProperties.builder().elementId(element.getId()).properties(properties).build();
        }).forEach(elementProperties::add);
        String xml = this.replacePlaceholders(snapshot, deployment);
        return DeploymentConfiguration.builder().xml(xml).properties(elementProperties).routes(this.deploymentRouteMapper.asUpdates(deployment.getDeploymentRoutes())).build();
    }

    private boolean containsCheckpointsElements(List<ElementProperties> elementProperties) {
        return elementProperties.stream().anyMatch(properties -> properties.getProperties() != null && "checkpoint".equals(properties.getProperties().get("elementType")));
    }

    private boolean containsSchedulerElements(List<ElementProperties> elementProperties) {
        return elementProperties.stream().anyMatch(properties -> properties.getProperties() != null && "quartz-scheduler".equals(properties.getProperties().get("elementType")));
    }

    private String replacePlaceholders(Snapshot snapshot, Deployment deployment) {
        StringBuilder result = DeploymentBuilderService.replacePlaceholder(snapshot.getXmlDefinition(), UUID.randomUUID().toString(), RANDOM_ID_PLACEHOLDER_PATTERN);
        result = DeploymentBuilderService.replacePlaceholder(result.toString(), deployment.getId(), DEPLOYMENT_ID_PLACEHOLDER_PATTERN);
        return result.toString().replace(DOMAIN_PLACEHOLDER, deployment.getDomain().toLowerCase());
    }

    @NotNull
    private static StringBuilder replacePlaceholder(String input, String replacement, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result;
    }
}

