/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionsDTO;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ImportInstructionResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.variable.ImportVariablesResult;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.ImportMode;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.variable.ImportVariablePreviewResult;
import org.qubership.integration.platform.runtime.catalog.rest.v3.dto.exportimport.variable.VariablesCommitRequest;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonVariablesImportService {
    private static final Logger log = LoggerFactory.getLogger(CommonVariablesImportService.class);
    private static final String VARIABLES_ARCH_PARENT_DIR = "variables";
    private static final String COMMON_VARIABLES_FILE_NAME = "common-variables.yaml";
    private static final String COMMON_VARIABLES_IMPORT_ENDPOINT = "/v2/common-variables/import";
    private static final String COMMON_VARIABLES_PREVIEW_ENDPOINT = "/v1/common-variables/preview";
    private static final String COMMON_VARIABLES_IMPORT_INSTRUCTIONS_ENDPOINT = "/v1/common-variables/import-instructions";
    private static final String COMMON_VARIABLES_IMPORT_INSTRUCTIONS_CONFIG_ENDPOINT = "/v1/common-variables/import-instructions/config";
    private static final String COMMON_VARIABLES_IMPORT_INSTRUCTIONS_UPLOAD_ENDPOINT = "/v1/common-variables/import-instructions/upload";
    private final RestTemplate restTemplate;
    private final String commonVariablesUrl;
    private final ImportSessionService importProgressService;

    @Autowired
    public CommonVariablesImportService(@Qualifier(value="restTemplateMS") RestTemplate restTemplate, @Value(value="${qip.internal-services.variables-management}") String variablesManagementHost, ImportSessionService importProgressService) {
        this.restTemplate = restTemplate;
        this.commonVariablesUrl = "http://" + variablesManagementHost + ":8080";
        this.importProgressService = importProgressService;
    }

    public ImportInstructionsDTO getCommonVariablesImportInstructions() {
        return (ImportInstructionsDTO)this.restTemplate.getForEntity(this.commonVariablesUrl + COMMON_VARIABLES_IMPORT_INSTRUCTIONS_ENDPOINT, ImportInstructionsDTO.class, new Object[0]).getBody();
    }

    public ImportInstructionsConfig getCommonVariablesImportInstructionsConfig() {
        return (ImportInstructionsConfig)this.restTemplate.getForEntity(this.commonVariablesUrl + COMMON_VARIABLES_IMPORT_INSTRUCTIONS_CONFIG_ENDPOINT, ImportInstructionsConfig.class, new Object[0]).getBody();
    }

    public List<ImportInstructionResult> uploadCommonVariablesImportInstructions(final String fileName, byte[] fileContent, Set<String> labels) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        if (CollectionUtils.isNotEmpty(labels)) {
            headers.put("labels", new ArrayList<String>(labels));
        }
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)new ByteArrayResource(fileContent){

            public String getFilename() {
                return fileName;
            }
        });
        return (List)this.restTemplate.exchange(this.commonVariablesUrl + COMMON_VARIABLES_IMPORT_INSTRUCTIONS_UPLOAD_ENDPOINT, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<List<ImportInstructionResult>>(){}, new Object[0]).getBody();
    }

    public void deleteCommonVariablesImportInstructions(Collection<String> variableIds) {
        this.restTemplate.exchange(this.commonVariablesUrl + COMMON_VARIABLES_IMPORT_INSTRUCTIONS_ENDPOINT, HttpMethod.DELETE, new HttpEntity(variableIds), Void.class, new Object[0]);
    }

    public List<ImportVariablePreviewResult> getCommonVariablesImportPreview(File importDirectory) {
        Object[] commonVariablesFiles = new File(String.valueOf(importDirectory) + File.separator + VARIABLES_ARCH_PARENT_DIR).listFiles(file -> COMMON_VARIABLES_FILE_NAME.equals(file.getName()));
        if (ArrayUtils.isEmpty((Object[])commonVariablesFiles)) {
            return Collections.emptyList();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.put((Object)"file", Collections.singletonList(new FileSystemResource((File)commonVariablesFiles[0])));
        return (List)this.restTemplate.exchange(this.commonVariablesUrl + COMMON_VARIABLES_PREVIEW_ENDPOINT, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<List<ImportVariablePreviewResult>>(){}, new Object[0]).getBody();
    }

    public ImportVariablesResult importCommonVariables(File importDirectory, VariablesCommitRequest variablesCommitRequest, String importId) {
        if (variablesCommitRequest.getImportMode() == ImportMode.NONE) {
            return new ImportVariablesResult();
        }
        Object[] commonVariablesFiles = new File(String.valueOf(importDirectory) + File.separator + VARIABLES_ARCH_PARENT_DIR).listFiles(file -> COMMON_VARIABLES_FILE_NAME.equals(file.getName()));
        if (ArrayUtils.isEmpty((Object[])commonVariablesFiles)) {
            return new ImportVariablesResult();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        MultipartBodyBuilder bodyBuilder = new MultipartBodyBuilder();
        bodyBuilder.part("file", (Object)new FileSystemResource((File)commonVariablesFiles[0]));
        if (variablesCommitRequest.getImportMode() == ImportMode.PARTIAL && variablesCommitRequest.getVariablesNames() != null) {
            bodyBuilder.part("variablesNames", (Object)String.join((CharSequence)",", variablesCommitRequest.getVariablesNames()));
        }
        ImportVariablesResult response = (ImportVariablesResult)this.restTemplate.exchange(this.commonVariablesUrl + COMMON_VARIABLES_IMPORT_ENDPOINT, HttpMethod.POST, new HttpEntity((Object)bodyBuilder.build(), (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<ImportVariablesResult>(){}, new Object[0]).getBody();
        this.importProgressService.calculateImportStatus(importId, 1, 1, 0, 10);
        return response;
    }
}

