/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;

@TemplatesHelper(value="if-element-type")
public class IfElementType
implements Helper<Object> {
    public static final String EQUALS = "equals";
    public static final String NOT_EQUALS = "not-equals";

    public Object apply(Object context, Options options) throws IOException {
        Context parentContext;
        Set keySet = options.hash.keySet();
        if (CollectionUtils.isEmpty(keySet)) {
            throw new IllegalArgumentException("Operation must be provided");
        }
        if (!(context instanceof ChainElement) && (parentContext = options.context.parent()) != null) {
            context = parentContext.model();
        }
        if (context instanceof ChainElement) {
            ChainElement element = (ChainElement)context;
            String operation = ((String)keySet.iterator().next()).toLowerCase();
            String expected = String.valueOf(options.hash.get(operation));
            if (this.test(element, expected, operation)) {
                options.buffer().append(options.fn());
            } else {
                options.buffer().append(options.inverse());
            }
        }
        return options.buffer();
    }

    private boolean test(ChainElement element, String expected, String operation) {
        return switch (operation) {
            case EQUALS -> StringUtils.equals((CharSequence)element.getType(), (CharSequence)expected);
            case NOT_EQUALS -> {
                if (!StringUtils.equals((CharSequence)element.getType(), (CharSequence)expected)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unsupported operation: " + operation);
        };
    }
}

