/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper;

import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.integration.platform.runtime.catalog.mapper.MapperException;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.EscapeUtil;

public class DictionaryEntryParser {
    private static final Pattern ENTRY_REGEX = Pattern.compile("((?:[^=;\\\\]|\\\\[=;\\\\])*)=((?:[^=;\\\\]|\\\\[=;\\\\])*)");

    public static Map.Entry<String, String> parse(String value) {
        Matcher matcher = ENTRY_REGEX.matcher(value);
        if (!matcher.matches()) {
            String message = String.format("Malformed dictionary entry: %s.", value);
            throw new MapperException(message);
        }
        return new AbstractMap.SimpleEntry<String, String>(EscapeUtil.unescape((String)matcher.group(1)), EscapeUtil.unescape((String)matcher.group(2)));
    }
}

