/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper.atlasmap.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.StringUtils;
import org.qubership.integration.platform.runtime.catalog.mapper.DataTypeUtils;
import org.qubership.integration.platform.runtime.catalog.mapper.atlasmap.xml.XmlTemplateCollectorContext;
import org.qubership.integration.platform.runtime.catalog.mapper.metadata.MetadataUtils;
import org.qubership.integration.platform.runtime.catalog.mapper.metadata.XMLNamespace;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.AllOfType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.AnyOfType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ArrayType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.BooleanType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.CompoundType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataTypeVisitor;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.IntegerType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.NullType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ObjectType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.OneOfType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ReferenceType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.StringType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Attribute;
import org.qubership.integration.platform.runtime.catalog.model.mapper.metadata.Metadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlTemplateCollector
implements DataTypeVisitor<Collection<Node>, XmlTemplateCollectorContext, Exception> {
    public Collection<Node> visitAllOfType(AllOfType type, XmlTemplateCollectorContext ctx) throws Exception {
        return this.visitCompoundType((CompoundType)type, ctx);
    }

    public Collection<Node> visitAnyOfType(AnyOfType type, XmlTemplateCollectorContext ctx) throws Exception {
        return this.visitCompoundType((CompoundType)type, ctx);
    }

    public Collection<Node> visitOneOfType(OneOfType type, XmlTemplateCollectorContext ctx) throws Exception {
        return this.visitCompoundType((CompoundType)type, ctx);
    }

    public Collection<Node> visitNullType(NullType type, XmlTemplateCollectorContext ctx) throws Exception {
        return Collections.singletonList(ctx.getDocument().createTextNode(""));
    }

    public Collection<Node> visitBooleanType(BooleanType type, XmlTemplateCollectorContext ctx) throws Exception {
        return Collections.singletonList(ctx.getDocument().createTextNode(""));
    }

    public Collection<Node> visitIntegerType(IntegerType type, XmlTemplateCollectorContext ctx) throws Exception {
        return Collections.singletonList(ctx.getDocument().createTextNode(""));
    }

    public Collection<Node> visitStringType(StringType type, XmlTemplateCollectorContext ctx) throws Exception {
        return Collections.singletonList(ctx.getDocument().createTextNode(""));
    }

    public Collection<Node> visitArrayType(ArrayType type, XmlTemplateCollectorContext ctx) throws Exception {
        return (Collection)type.getItemType().accept((DataTypeVisitor)this, (Object)XmlTemplateCollector.addDefinitionsToContext((XmlTemplateCollectorContext)ctx, (Collection)type.getDefinitions()));
    }

    public Collection<Node> visitObjectType(ObjectType type, XmlTemplateCollectorContext ctx) throws Exception {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Attribute attribute : type.getSchema().getAttributes()) {
            if (XmlTemplateCollector.isXmlTextNode((Attribute)attribute) || XmlTemplateCollector.isXmlAttribute((Attribute)attribute)) continue;
            Node node = this.buildElementNode(attribute, XmlTemplateCollector.addDefinitionsToContext((XmlTemplateCollectorContext)ctx, (Collection)type.getDefinitions()));
            result.add(node);
        }
        return result;
    }

    public Collection<Node> visitReferenceType(ReferenceType type, XmlTemplateCollectorContext ctx) throws Exception {
        Map definitionMap = Stream.of(ctx.getDefinitions(), type.getDefinitions()).flatMap(Collection::stream).collect(Collectors.toMap(TypeDefinition::getId, Function.identity()));
        DataTypeUtils.ResolveResult resolveResult = DataTypeUtils.resolveType((DataType)type, definitionMap);
        return (Collection)resolveResult.type().accept((DataTypeVisitor)this, (Object)ctx.toBuilder().definitions(resolveResult.definitionMap().values()).build());
    }

    private Collection<Node> visitCompoundType(CompoundType type, XmlTemplateCollectorContext ctx) throws Exception {
        ArrayList<Node> result = new ArrayList<Node>();
        for (DataType subType : type.getTypes()) {
            result.addAll((Collection)subType.accept((DataTypeVisitor)this, (Object)XmlTemplateCollector.addDefinitionsToContext((XmlTemplateCollectorContext)ctx, (Collection)type.getDefinitions())));
        }
        return result;
    }

    private Node buildElementNode(Attribute attribute, XmlTemplateCollectorContext ctx) throws Exception {
        String namespace = XmlTemplateCollector.getNamespace((Attribute)attribute);
        Collection namespaces = XmlTemplateCollector.getXmlNamespaces((Attribute)attribute, (XmlTemplateCollectorContext)ctx);
        XmlTemplateCollectorContext subCtx = XmlTemplateCollector.addNamespacesToContext((XmlTemplateCollectorContext)ctx, (Collection)namespaces);
        String namespaceUri = subCtx.getNamespaces().getOrDefault(namespace, "");
        Element element = subCtx.getDocument().createElementNS(namespaceUri, attribute.getName());
        XmlTemplateCollector.addNamespacesToElement((Element)element, (Collection)namespaces);
        for (Node node : (Collection)attribute.getType().accept((DataTypeVisitor)this, (Object)subCtx)) {
            if (node instanceof Attr) {
                element.setAttributeNodeNS((Attr)node);
                continue;
            }
            element.appendChild(node);
        }
        return element;
    }

    private static XmlTemplateCollectorContext addDefinitionsToContext(XmlTemplateCollectorContext ctx, Collection<TypeDefinition> definitions) {
        ArrayList<TypeDefinition> newDefinitions = new ArrayList<TypeDefinition>(ctx.getDefinitions());
        newDefinitions.addAll(definitions);
        return ctx.toBuilder().definitions(newDefinitions).build();
    }

    private static XmlTemplateCollectorContext addNamespacesToContext(XmlTemplateCollectorContext ctx, Collection<XMLNamespace> namespaces) {
        HashMap namespacesMap = new HashMap(ctx.getNamespaces());
        namespaces.forEach(namespace -> namespacesMap.put(namespace.alias(), namespace.uri()));
        return ctx.toBuilder().namespaces(namespacesMap).build();
    }

    private static boolean isXmlAttribute(Attribute attribute) {
        return attribute.getName().startsWith("@");
    }

    private static boolean isXmlTextNode(Attribute attribute) {
        return attribute.getName().equals("#text");
    }

    private static String getNamespace(Attribute attribute) {
        int index;
        String s = attribute.getName();
        if (s.startsWith("@")) {
            s = s.substring(1);
        }
        return (index = s.indexOf(":")) < 0 ? null : s.substring(0, index);
    }

    private static Collection<XMLNamespace> getXmlNamespaces(Attribute attribute, XmlTemplateCollectorContext ctx) {
        DataType type = attribute.getType();
        Map definitionMap = ctx.getDefinitions().stream().collect(Collectors.toMap(TypeDefinition::getId, Function.identity()));
        definitionMap = DataTypeUtils.updateDefinitionMapFromType(definitionMap, (DataType)type);
        DataTypeUtils.ResolveResult resolveResult = DataTypeUtils.resolveType((DataType)type, (Map)definitionMap);
        return MetadataUtils.getXmlNamespaces((Metadata)resolveResult.type().getMetadata());
    }

    private static void addNamespacesToElement(Element node, Collection<XMLNamespace> namespaces) {
        for (XMLNamespace namespace : namespaces) {
            Object attributeName = "xmlns";
            if (!StringUtils.isBlank((String)namespace.alias())) {
                attributeName = (String)attributeName + ":" + namespace.alias();
            }
            node.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)attributeName, namespace.uri());
        }
    }
}

