/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.SnapshotMapper;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/chains/{chainId}/snapshots"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="snapshot-controller", description="Snapshot Controller")
public class SnapshotController {
    private static final Logger log = LoggerFactory.getLogger(SnapshotController.class);
    private final SnapshotService snapshotService;
    private final SnapshotMapper snapshotMapper;

    @Autowired
    public SnapshotController(SnapshotService snapshotService, SnapshotMapper snapshotMapper) {
        this.snapshotService = snapshotService;
        this.snapshotMapper = snapshotMapper;
    }

    @GetMapping
    @Operation(description="Find all snapshots by specified chain without xml definition")
    public ResponseEntity<List<SnapshotResponse>> findByChainIdLight(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find all snapshots for chain: {}", (Object)chainId);
        }
        List entities = this.snapshotService.findByChainIdLight(chainId);
        List responseList = this.snapshotMapper.asResponse(entities);
        responseList.forEach(snapshotDto -> snapshotDto.setXmlDefinition(null));
        return ResponseEntity.ok((Object)responseList);
    }

    @GetMapping(value={"/{snapshotId}"})
    @Operation(description="Get particular snapshot")
    public ResponseEntity<SnapshotResponse> findById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id") String snapshotId, @RequestParam(required=false, defaultValue="false") @Parameter(description="Whether response should not include xml definition of the chain") boolean light) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find snapshot {} in chain {}: ", (Object)snapshotId, (Object)chainId);
        }
        Snapshot entity = this.snapshotService.findById(snapshotId);
        SnapshotResponse response = this.snapshotMapper.asResponse(entity);
        if (light) {
            response.setXmlDefinition(null);
        }
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    @Operation(description="Generate snapshot on current chain state")
    public ResponseEntity<SnapshotResponse> build(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to build snapshot for chain with id: {}", (Object)chainId);
        Snapshot entity = this.snapshotService.build(chainId);
        SnapshotResponse response = this.snapshotMapper.asResponse(entity);
        response.setXmlDefinition(null);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{snapshotId}"})
    @Operation(description="Update information for particular snapshot")
    public ResponseEntity<SnapshotResponse> updateSnapshot(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id") String snapshotId, @RequestBody @Parameter(description="Snapshot update request object") SnapshotRequest request) {
        log.info("Request to build snapshot for chain with id: {}", (Object)chainId);
        Snapshot snapshot = this.snapshotService.merge(chainId, snapshotId, this.snapshotMapper.asRequest(request));
        SnapshotResponse response = this.snapshotMapper.asResponse(snapshot);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(path={"/{snapshotId}/revert"}, produces={"application/json"})
    @Operation(description="Revert chain state to specified snapshot")
    public ResponseEntity<SnapshotResponse> revert(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id") String snapshotId) {
        log.info("Request to revert chain with id: {}, to snapshot id: {}", (Object)chainId, (Object)snapshotId);
        Snapshot entity = this.snapshotService.revert(chainId, snapshotId);
        SnapshotResponse response = this.snapshotMapper.asResponse(entity);
        response.setXmlDefinition(null);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping
    @Operation(description="Delete all snapshots from specified chain")
    public ResponseEntity<Void> deleteAllByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to delete all snapshots from chain: {}", (Object)chainId);
        this.snapshotService.deleteAllByChainId(chainId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @DeleteMapping(value={"/{snapshotId}"})
    @Operation(description="Delete specified snapshot")
    public ResponseEntity<Void> deleteById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Snapshot id") String snapshotId) {
        log.info("Request to delete snapshot with id {} in chain {}", (Object)snapshotId, (Object)chainId);
        this.snapshotService.deleteById(snapshotId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

