/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationChainEntityDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationStatusDTO;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;

@Schema(description="Response object for diagnostic validation entity")
public class DiagnosticValidationDTO {
    @Schema(description="Validation id")
    private String id;
    @Schema(description="Validation name")
    private String title;
    @Schema(description="Validation description")
    private String description;
    @Schema(description="Validation suggestion (hint)")
    private String suggestion;
    @Schema(description="Type of entity with which validation works")
    private ValidationEntityType entityType;
    @Schema(description="Validation implementation source")
    private ValidationImplementationType implementationType;
    @Schema(description="Validation severity")
    private ValidationSeverity severity;
    @Schema(description="Validation execution properties in key:value format")
    private Map<String, Object> properties;
    @Schema(description="Validation last execution status")
    private ValidationStatusDTO status;
    @Schema(description="Validation alerts count")
    private long alertsCount;
    @Nullable
    @Schema(description="Entities related to this validation in which problems were found as a result of diagnostics")
    private List<ValidationChainEntityDTO> chainEntities;

    DiagnosticValidationDTO(String id, String title, String description, String suggestion, ValidationEntityType entityType, ValidationImplementationType implementationType, ValidationSeverity severity, Map<String, Object> properties, ValidationStatusDTO status, long alertsCount, @Nullable List<ValidationChainEntityDTO> chainEntities) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.suggestion = suggestion;
        this.entityType = entityType;
        this.implementationType = implementationType;
        this.severity = severity;
        this.properties = properties;
        this.status = status;
        this.alertsCount = alertsCount;
        this.chainEntities = chainEntities;
    }

    public static DiagnosticValidationDTOBuilder builder() {
        return new DiagnosticValidationDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public ValidationEntityType getEntityType() {
        return this.entityType;
    }

    public ValidationImplementationType getImplementationType() {
        return this.implementationType;
    }

    public ValidationSeverity getSeverity() {
        return this.severity;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ValidationStatusDTO getStatus() {
        return this.status;
    }

    public long getAlertsCount() {
        return this.alertsCount;
    }

    @Nullable
    public List<ValidationChainEntityDTO> getChainEntities() {
        return this.chainEntities;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public void setEntityType(ValidationEntityType entityType) {
        this.entityType = entityType;
    }

    public void setImplementationType(ValidationImplementationType implementationType) {
        this.implementationType = implementationType;
    }

    public void setSeverity(ValidationSeverity severity) {
        this.severity = severity;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setStatus(ValidationStatusDTO status) {
        this.status = status;
    }

    public void setAlertsCount(long alertsCount) {
        this.alertsCount = alertsCount;
    }

    public void setChainEntities(@Nullable List<ValidationChainEntityDTO> chainEntities) {
        this.chainEntities = chainEntities;
    }
}

