/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.exception;

import com.github.jknack.handlebars.internal.lang3.StringUtils;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.exception.ConstraintViolationException;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import org.qubership.integration.platform.catalog.exception.CatalogRuntimeException;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceClientException;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceException;
import org.qubership.integration.platform.catalog.exception.ComparisonEntityNotFoundException;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsExternalException;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsInternalException;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.exception.SpecificationImportException;
import org.qubership.integration.platform.catalog.exception.SpecificationImportWarningException;
import org.qubership.integration.platform.runtime.catalog.kubernetes.KubeApiException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.ExceptionDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ApiSpecificationExportException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ChainExportException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.DeploymentProcessingException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.EnvironmentSetUpException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.ValidationAlreadyInProgressUnexpectedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler
    public ResponseEntity<ExceptionDTO> handleGeneralException(Exception exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleEntityNotFound() {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={ChainExportException.class})
    public ResponseEntity<ExceptionDTO> handleChainExportException(ChainExportException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ApiSpecificationExportException.class})
    public ResponseEntity<ExceptionDTO> handleApiSpecificationExportException(ApiSpecificationExportException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={EntityExistsException.class})
    public ResponseEntity<ExceptionDTO> handleEntityExistsException(EntityExistsException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={KubeApiException.class})
    public ResponseEntity<ExceptionDTO> handleApiException(KubeApiException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SnapshotCreationException.class})
    public ResponseEntity<ExceptionDTO> handleSnapshotCreationException(SnapshotCreationException exception) {
        Map<String, String> details = StringUtils.isBlank((CharSequence)exception.getElementId()) ? null : Map.of("chainId", exception.getChainId(), "elementId", exception.getElementId(), "elementName", exception.getElementName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)((Object)exception), details));
    }

    @ExceptionHandler(value={DeploymentProcessingException.class})
    public ResponseEntity<ExceptionDTO> handleDeploymentDeletionException(DeploymentProcessingException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SpecificationImportException.class, IOException.class})
    public ResponseEntity<ExceptionDTO> handleImportException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SpecificationImportWarningException.class})
    public ResponseEntity<ExceptionDTO> handleImportWarningException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={EnvironmentSetUpException.class})
    public ResponseEntity<ExceptionDTO> handleEnvironmentSetUpException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ValidationAlreadyInProgressUnexpectedException.class})
    public final ResponseEntity<ExceptionDTO> handleDatabaseSystemException(ValidationAlreadyInProgressUnexpectedException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={DiagnosticValidationUnexpectedException.class})
    public final ResponseEntity<ExceptionDTO> handleDatabaseSystemException(DiagnosticValidationUnexpectedException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ComparisonEntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleComparisonEntityNotFoundException(ComparisonEntityNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ChainDifferenceClientException.class})
    public ResponseEntity<ExceptionDTO> handleChainDifferenceClientException(ChainDifferenceClientException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ChainDifferenceException.class})
    public ResponseEntity<ExceptionDTO> handleChainDifferenceException(ChainDifferenceException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ImportInstructionsInternalException.class})
    public ResponseEntity<ExceptionDTO> handleImportInstructionsInternalException(ImportInstructionsInternalException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ImportInstructionsExternalException.class})
    public ResponseEntity<ExceptionDTO> handleImportInstructionsExternalException(ImportInstructionsExternalException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={jakarta.validation.ConstraintViolationException.class})
    public ResponseEntity<ExceptionDTO> handleConstraintViolationException(jakarta.validation.ConstraintViolationException exception) {
        String errorMessage = exception.getConstraintViolations().stream().map(violation -> violation.getPropertyPath().toString() + " " + violation.getMessage()).collect(Collectors.joining(", ", "Invalid request content: [", "]"));
        ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(errorMessage).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exceptionDTO);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<ExceptionDTO> handleDataIntegrityViolationException(DataIntegrityViolationException exception) {
        ConstraintViolationException constraintException;
        Throwable throwable = exception.getCause();
        if (throwable instanceof ConstraintViolationException && "import_instructions_unique_override_idx".equals((constraintException = (ConstraintViolationException)throwable).getConstraintName())) {
            return this.handleImportInstructionsExternalException(new ImportInstructionsExternalException(this.extractConstraintMessage(constraintException)));
        }
        return this.handleGeneralException((Exception)exception);
    }

    private ExceptionDTO getExceptionDTO(Exception exception) {
        return this.getExceptionDTO(exception, null);
    }

    private ExceptionDTO getExceptionDTO(Exception exception, Map<String, Object> details) {
        return ExceptionDTO.builder().errorMessage(exception.getMessage()).errorDate(new Timestamp(System.currentTimeMillis()).toString()).details(details).build();
    }

    private String extractConstraintMessage(ConstraintViolationException exception) {
        Optional<ServerErrorMessage> serverErrorMessage = Optional.empty();
        SQLException sQLException = exception.getSQLException();
        if (sQLException instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)sQLException;
            serverErrorMessage = Optional.ofNullable(psqlException.getServerErrorMessage());
        } else if (exception.getSQLException() != null && (sQLException = exception.getSQLException().getNextException()) instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)sQLException;
            serverErrorMessage = Optional.ofNullable(psqlException.getServerErrorMessage());
        }
        return serverErrorMessage.map(errorMessage -> errorMessage.getDetail() + " already overrides or overridden by another chain").orElse("Instruction for the chain already exist");
    }
}

